% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list2incidenceMatrix.R
\name{list2incidenceMatrix}
\alias{list2incidenceMatrix}
\title{Convert a list of character strings into an incidence matrix}
\usage{
list2incidenceMatrix(list, type = c("binary", "count"))
}
\arguments{
\item{list}{A list of character strings, can be unique or redundant}

\item{type}{How the values of the incidence matrix will be filled, see details.}
}
\value{
An incidence matrix, containing either binary (\code{TRUE/FALSE}) or integer values.

Type 'binary' will produce a logical matrix, whereas 'count' will produce a matrix
where the frequency of the character strings in the list.
}
\description{
Convert a list of character strings into an incidence matrix
}
\examples{
wordList <- list("2006"=c("HSV", "BVB", "FCB"), 
  "2007"=c("BVB", "VFB", "STP"), 
  "2008"=c("VFL", "BVB", "HSV"))
list2incidenceMatrix(wordList, type="binary")

letterList <- list("First"=c("A", "a", "A", "a"), "Second"=c("B", "b", "A"))
list2incidenceMatrix(letterList, type="count")
list2incidenceMatrix(letterList, type="binary")

}
\author{
Jitao David Zhang, \email{jitao_david.zhang@roche.com}
}
