#' Parse a CIGAR string into a data frame
#'
#' @param cigar A CIGAR string
#' 
#' @return A data frame of opreations and numbers in the CIGAR string
#' 
#' @examples
#' \dontrun{
#'     parseCIGAR()
#' }
#'
#' @noRd
parseCIGAR <- function( cigar ){
	op.length <- as.numeric(unlist(strsplit(cigar, "[MIDNSHP=X]") ) )
	op.index <- unlist(gregexpr("[MIDNSHP=X]", cigar) )
	op.code <- substring(cigar, op.index, op.index)
	op <- data.frame( code = op.code, length = op.length, stringsAsFactors = FALSE )
	return(op)
}
