% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot.R
\name{pivot_textgrid_tiers}
\alias{pivot_textgrid_tiers}
\title{Pivot a textgrid into wide format, respecting nested tiers}
\usage{
pivot_textgrid_tiers(data, tiers, join_cols = "file")
}
\arguments{
\item{data}{a textgrid dataframe created with \code{\link[=read_textgrid]{read_textgrid()}}}

\item{tiers}{character vector of tiers to pivot into wide format. When
\code{tiers} has more than 1 element, the tiers are treated as nested. For
example, if \code{tiers} is \code{c("utterance", "word", "phone")}, where
\code{"utterance"} intervals contain \code{"word"} intervals which in turn contain
\code{"phone"} intervals, the output will have one row per \code{"phone"} interval
and include \verb{utterance_*} and \verb{word_*} columns for the utterance and word
intervals that contain each phone interval. \code{tiers} should be ordered from
broadest to narrowest (e.g, \code{"word"} preceding \code{"phone"}).}

\item{join_cols}{character vector of the columns that will uniquely identify
a textgrid file. Defaults to \code{"file"} because
these columns have identical values for tiers read from the same textgrid
file.}
}
\value{
a dataframe with just the intervals from tiers named in \code{tiers}
converted into a wide format. Columns are renamed so that the \code{text} column
is pivot into columns named after the tier names. For example, the \code{text}
column in a \code{words} tier is renamed to \code{words}. The \code{xmax}, \code{xmin},
\code{annotation_num}, \code{tier_num}, \code{tier_type} are also prefixed with the tier
name. For example, the \code{xmax} column in a \code{words} tier is renamed to
\code{words_xmax}. An additional helper column \code{xmid} is added and prefixed
appropriately. See examples below.
}
\description{
Pivot a textgrid into wide format, respecting nested tiers
}
\details{
For the joining nested intervals, two intervals \emph{a} and \emph{b} are combined into
the same row if they match on the values in the \code{join_cols} columns and if
the \code{a$xmin <= b$xmid} and \code{b$xmid <= a$xmax}. That is, if the midpoint of
\emph{b} is contained inside the interval \emph{a}.
}
\examples{
data <- example_textgrid(3) |>
  read_textgrid()
data

# With a single tier, we get just that tier with the columns prefixed with
# the tier_name
pivot_textgrid_tiers(data, "utterance")
pivot_textgrid_tiers(data, "words")

# With multiple tiers, intervals in one tier that contain intervals in
# another tier are combined into the same row.
a <- pivot_textgrid_tiers(data, c("utterance", "words"))
cols <- c(
  "utterance", "utterance_xmin", "utterance_xmax",
  "words", "words_xmin", "words_xmax"
)
a[cols]

a <- pivot_textgrid_tiers(data, c("utterance", "words", "phones"))
cols <- c(cols, "phones", "phones_xmin", "phones_xmax")
a[cols]
}
