% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcatfish_collections.R
\name{rcatfish_collections}
\alias{rcatfish_collections}
\title{Accesses the Eschmeyer's Catalog of Fishes Guide to Fish Collections}
\usage{
rcatfish_collections(
  query = NULL,
  abbreviation = NULL,
  country = NULL,
  phrase = FALSE,
  sleep.time = 10,
  verbose = TRUE
)
}
\arguments{
\item{query}{Character Vector of search terms to search for. Default is NULL.}

\item{abbreviation}{Character vector containing the musuem collection code(s). Default is NULL.}

\item{country}{Character vector of country names to search for. Default is NULL.}

\item{phrase}{Logical. Should query be passed as a quoted phrase (e.g. "Museum of Zoology"). Default is FALSE.}

\item{sleep.time}{Numeric. Time in seconds to sleep between query calls to the California Academy of Sciences page. This is set by default to 10 seconds, which is in their robots.txt. Adjust at your own risk.}

\item{verbose}{Logical. Should query progress be messaged to the screen? Default is TRUE.}
}
\value{
Data frame, in which each row is a natural history collection and each column the corresponding collection information (see itemized list below).
\itemize{
\item Code - Character. Natural history collection abbreviation code.
\item Name  - Character. Full name of the natural history collection.
\item Country  - Character. Country of the natural history collection.
\item OtherAbbr - Character. Other and previous abbreviation(s) used for that natural history collection.
\item OldName - Character. Previous name(s) used by the natural history.
\item NewName - Character. New name(s) of the natural history collection.
\item WebPage - Character. URL for the webpage of the natural history collection if one exists.
\item CollectionDB - Character. URL for accessing the collection database of the natural history collection if one exists.
\item TypesDB - Character. URL for accessing the type database of the natural history collection if one exists.
\item Remarks - Character. Additional information about the natural history collection (e.g. includes specimens from other collections, closed, etc.).
\item Publications - Character. Comma separated character vector of Eschmeyer's Catalog of Fishes reference numbers citing the natural history collection.
}
}
\description{
Accesses the Eschmeyer's Catalog of Fishes Guide to Fish Collections
}
\details{
This function retrieves and parses natural history collection data from the Eschmeyer's Catalog of
Fishes. Returned information includes the collection abbreviation, country, alternate abbreviations,
old and new collection names, websites and databases associated with the collection, remarks, and
publications associated with the collection.

It is important that search criteria match exactly how they are on the Catalog of Fishes, otherwise
data will not be found (case must match, spelling, etc.). Users wishing to query more than one query
mixed with either a country or abbreviation should note that all parameters must be of equal length, so if searching
two queries both in U.S.A., the country should be supplied twice (see the final example in the examples below).
}
\examples{
#Search Museum Code For UMMZ (University of Michigan Museum of Zoology)
my.collections <- rcatfish_collections(abbreviation = "UMMZ", country = NULL, 
query = NULL, verbose = TRUE)
\donttest{
#Search For Collections in France
my.collections <- rcatfish_collections(abbreviation = NULL, country = "France", query = NULL)
#Search For Collections in The United States that are in Illinois
my.collections <- rcatfish_collections(abbreviation = NULL, country = "U.S.A.", query = "Illinois")
#Search For Collections in the United States that are in California & Alaska.
my.collections <- rcatfish_collections(abbreviation = NULL, country = rep("U.S.A.",2), 
query = c("California","Alaska"), sleep.time = 10)
#Search for Collections with Museum of Zoology in the name
my.collections <- rcatfish_collections(query = "Museum of Zoology", phrase = TRUE)
}
}
\references{
Fricke, R. & Eschmeyer, W.N. (Year Accessed). Eschmeyer's Catalog of Fishes: Guide to Fish Collections. https://researcharchive.calacademy.org/research/ichthyology/catalog/collections.asp.
}
\author{
Samuel R. Borstein
}
