% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatting.R
\name{format_results_table}
\alias{format_results_table}
\title{Format Results Table for Publication}
\usage{
format_results_table(
  data,
  est_col = "est",
  lci_col = "lci",
  uci_col = "uci",
  pval_col = "pval",
  est_digits = 2,
  pval_digits = 3,
  pval_threshold = 0.001,
  ci_sep = ", "
)
}
\arguments{
\item{data}{A data.frame or tibble, typically output from \code{\link[=tidy_pool_obj]{tidy_pool_obj()}}.}

\item{est_col}{Character. Name of the estimate column. Default is "est".}

\item{lci_col}{Character. Name of the lower CI column. Default is "lci".}

\item{uci_col}{Character. Name of the upper CI column. Default is "uci".}

\item{pval_col}{Character. Name of the p-value column. Default is "pval".}

\item{est_digits}{Integer. Decimal places for estimates. Default is 2.}

\item{pval_digits}{Integer. Decimal places for p-values. Default is 3.}

\item{pval_threshold}{Numeric. Threshold for p-value formatting. Default is 0.001.}

\item{ci_sep}{Character. Separator for CI bounds. Default is ", ".}
}
\value{
A tibble with additional formatted columns:
\describe{
\item{est_ci}{Formatted estimate with confidence interval}
\item{pval_fmt}{Formatted p-value}
}
}
\description{
Adds formatted columns to a tidy results table, creating publication-ready
output with properly formatted estimates, confidence intervals, and p-values.
}
\details{
This function is designed to work with output from \code{\link[=tidy_pool_obj]{tidy_pool_obj()}} but
can be used with any data.frame containing estimate, CI, and p-value columns.
The original columns are preserved; new formatted columns are added.
}
\examples{
library(dplyr)

# Create example results
results <- tibble::tibble(
  parameter = c("trt_Week24", "lsm_ref_Week24", "lsm_alt_Week24"),
  description = c("Treatment Effect", "LS Mean (Reference)", "LS Mean (Treatment)"),
  est = c(-2.45, 5.20, 2.75),
  se = c(0.89, 0.65, 0.71),
  lci = c(-4.20, 3.93, 1.36),
  uci = c(-0.70, 6.47, 4.14),
  pval = c(0.006, NA, NA)
)

# Format for publication
formatted <- format_results_table(results)
print(formatted[, c("description", "est_ci", "pval_fmt")])

}
