% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/result_helpers.R
\name{extract_lsm}
\alias{extract_lsm}
\title{Extract Least Squares Means}
\usage{
extract_lsm(results, visit = NULL, arm = NULL)
}
\arguments{
\item{results}{A tibble from \code{\link[=tidy_pool_obj]{tidy_pool_obj()}}.}

\item{visit}{Optional character vector of visits to filter. If NULL (default),
returns results for all visits.}

\item{arm}{Optional character: "ref" for reference arm, "alt" for alternative arm,
or NULL (default) for both.}
}
\value{
A tibble containing only LSM rows.
}
\description{
Convenience function to extract only least squares mean estimates from
tidy results.
}
\examples{
\donttest{
library(rbmi)

# Assuming you have a tidy result
# tidy_result <- tidy_pool_obj(pool_obj)
# all_lsm <- extract_lsm(tidy_result)
# ref_lsm <- extract_lsm(tidy_result, arm = "ref")
}

}
\seealso{
\itemize{
\item \code{\link[=tidy_pool_obj]{tidy_pool_obj()}} to create tidy results
\item \code{\link[=extract_trt_effects]{extract_trt_effects()}} to extract treatment effects
}
}
