% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/result_helpers.R
\name{combine_results}
\alias{combine_results}
\title{Combine Results Across Multiple Analyses}
\usage{
combine_results(..., results_list = NULL, id_col = "analysis")
}
\arguments{
\item{...}{Named arguments where each is a tidy result tibble from \code{\link[=tidy_pool_obj]{tidy_pool_obj()}}.}

\item{results_list}{Alternative to \code{...}: a named list of tidy result tibbles.}

\item{id_col}{Character string specifying the name of the identifier column.
Default is "analysis".}
}
\value{
A tibble with all results combined, with an additional column identifying
the source analysis.
}
\description{
Combines tidy result tibbles from multiple analyses (e.g., different endpoints
or subgroups) into a single table with an identifying column.
}
\examples{
\donttest{
library(rbmi)
library(dplyr)

# Assuming you have multiple pooled results
# results_week24 <- tidy_pool_obj(pool_obj_week24)
# results_week48 <- tidy_pool_obj(pool_obj_week48)

# Combine them
# combined <- combine_results(
#   "Week 24" = results_week24,
#   "Week 48" = results_week48
# )
}

}
\seealso{
\itemize{
\item \code{\link[=tidy_pool_obj]{tidy_pool_obj()}} to create tidy results from pooled objects
\item \code{\link[=format_results]{format_results()}} to format combined results for reporting
}
}
