% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/by_group.R
\name{by_group}
\alias{by_group}
\title{Wrapper function to run multiple instances of \code{\link{rblimp}} based on grouping variable}
\usage{
by_group(expr, group)
}
\arguments{
\item{expr}{a call to \code{\link{rblimp}} or \code{\link{rblimp_fcs}}.}

\item{group}{a character vector or index pointing to grouping variable in data set}
}
\value{
a list of all blimp runs by group with class of \code{blimp_bygroup}
}
\description{
\code{rblimp} will generate the input, run the script, and load most the saved data into an R object. \code{rblimp_fcs}
is used to specify the FCS command in Blimp. \code{rblimp_syntax} will generate the Blimp syntax file only.
}
\details{
Separates by grouping to run blimp command on each individual sub data set.
}
\examples{
\dontshow{if (has_blimp()) withAutoprint(\{ # examplesIf}
# Generate Data
mydata <- rblimp_sim(
    c(
        'x ~ normal(0, 1)',
        'y ~ normal(0, 1)',
        'group = uniform(0, 1) < 0.5'
    ),
    n = 1000,
    seed = 10972
)

# Nonsensical model
mdl <- rblimp_fcs(
    c('x', 'y'),
    mydata,
    seed = 3927,
    nimps = 2,
) |> by_group('group')

# Analyze each imputation
results <- with(mdl, lm(y ~ x))
# use `mitml` package to pool results
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{as.mitml}}
}
