% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imaging-registration.R
\name{register_volume}
\alias{register_volume}
\title{Imaging registration using \code{'NiftyReg'}}
\usage{
register_volume(
  source,
  target,
  method = c("rigid", "affine", "nonlinear"),
  interpolation = c("cubic", "trilinear", "nearest"),
  threads = detect_threads(),
  symmetric = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{source}{source imaging data, or a \code{'nifti'} file path;
for example, 'CT'}

\item{target}{target imaging data to align to; for example, 'MRI'}

\item{method}{method of transformation, choices are \code{'rigid'},
\code{'affine'}, or \code{'nonlinear'}}

\item{interpolation}{how volumes should be interpolated, choices are
\code{'cubic'}, \code{'trilinear'}, or \code{'nearest'}}

\item{threads, symmetric, verbose, ...}{see \code{\link[RNiftyReg]{niftyreg}}}
}
\value{
See \code{\link[RNiftyReg]{niftyreg}}
}
\description{
Registers 'CT' to 'MRI', or 'MRI' to another 'MRI'
}
\examples{

\donttest{

source <- system.file("extdata", "epi_t2.nii.gz", package="RNiftyReg")
target <- system.file("extdata", "flash_t1.nii.gz", package="RNiftyReg")
aligned <- register_volume(source, target, verbose = FALSE)

source_img <- aligned$source[[1]]
target_img <- aligned$target
aligned_img <- aligned$image

oldpar <- par(mfrow = c(2, 2), mar = c(0.1, 0.1, 3.1, 0.1))

pal <- grDevices::grey.colors(256, alpha = 1)
image(source_img[,,30], asp = 1, axes = FALSE,
      col = pal, main = "Source image")
image(target_img[,,64], asp = 1, axes = FALSE,
      col = pal, main = "Target image")
image(aligned_img[,,64], asp = 1, axes = FALSE,
      col = pal, main = "Aligned image")

# bucket fill and calculate differences
aligned_img[is.nan(aligned_img) | aligned_img <= 1] <- 1
target_img[is.nan(target_img) | aligned_img <= 1] <- 1
diff <- abs(aligned_img / target_img - 1)
image(diff[,,64], asp = 1, axes = FALSE,
      col = pal, main = "Percentage Difference")

par(oldpar)

}

}
