% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometry-plane.R
\name{plane_geometry}
\alias{plane_geometry}
\title{Create a two-dimensional plane in three dimensional space}
\usage{
plane_geometry(width = 1, height = 1, shape = c(2, 2))
}
\arguments{
\item{width, height}{width and height of the plane, must not be \code{NA}}

\item{shape}{length of two to indicate the number of vertices along width
and height, default is only \code{c(2, 2)} (2 vertices each side, hence
one grid)}
}
\value{
A triangular mesh of class \code{'mesh3d'}
}
\description{
Create a two-dimensional plane in three dimensional space
}
\examples{

plane <- plane_geometry(5, 10, c(12, 22))

if(FALSE) {

  rgl_view({

    rgl_call("shade3d", plane, col = 3)
    rgl_call("wire3d", plane, col = 1)

  })

}

}
