% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline-tools.R
\name{pipeline_settings_get_set}
\alias{pipeline_settings_get_set}
\alias{pipeline_settings_set}
\alias{pipeline_settings_get}
\title{Get or change pipeline input parameter settings}
\usage{
pipeline_settings_set(
  ...,
  pipeline_path = Sys.getenv("RAVE_PIPELINE", "."),
  pipeline_settings_path = file.path(pipeline_path, "settings.yaml")
)

pipeline_settings_get(
  key,
  default = NULL,
  constraint = NULL,
  pipeline_path = Sys.getenv("RAVE_PIPELINE", "."),
  pipeline_settings_path = file.path(pipeline_path, "settings.yaml")
)
}
\arguments{
\item{pipeline_path}{the root directory of the pipeline}

\item{pipeline_settings_path}{the settings file of the pipeline, must be
a 'yaml' file; default is \code{'settings.yaml'} in the current pipeline}

\item{key, ...}{the character key(s) to get or set}

\item{default}{the default value is key is missing}

\item{constraint}{the constraint of the resulting value; if not \code{NULL},
then result must be within the \code{constraint} values, otherwise the
first element of \code{constraint} will be returned. This is useful to make
sure the results stay within given options}
}
\value{
\code{pipeline_settings_set} returns a list of all the settings.
\code{pipeline_settings_get} returns the value of given key.
}
\description{
Get or change pipeline input parameter settings
}
\examples{



root_path <- tempfile()
pipeline_root_folder <- file.path(root_path, "modules")

# create pipeline folder
pipeline_path <- pipeline_create_template(
  root_path = pipeline_root_folder, pipeline_name = "raveio_demo",
  overwrite = TRUE, activate = FALSE, template_type = "rmd-bare")

# Set initial user inputs
yaml::write_yaml(
  x = list(
    n = 100,
    pch = 16,
    col = "steelblue"
  ),
  file = file.path(pipeline_path, "settings.yaml")
)

# build the pipeline for the first time
# this is a one-time setup
pipeline_build(pipeline_path)

# get pipeline settings
pipeline_settings_get(
  key = "n",
  pipeline_path = pipeline_path
)

# get variable with default if missing
pipeline_settings_get(
  key = "missing_variable",
  default = "missing",
  pipeline_path = pipeline_path
)

pipeline_settings_set(
  missing_variable = "A",
  pipeline_path = pipeline_path
)

pipeline_settings_get(
  key = "missing_variable",
  default = "missing",
  pipeline_path = pipeline_path
)


unlink(root_path, recursive = TRUE)


}
