% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reptools.r
\name{makegraphviz}
\alias{makegraphviz}
\title{makegraphviz}
\usage{
makegraphviz(.object., ..., file)
}
\arguments{
\item{.object.}{character string or vector with \code{graphviz} markup}

\item{...}{name=value pairs that makes values replace \code{{{name}}} elements in the markup}

\item{file}{name of file to hold \code{graphviz} markup after variable insertions.  Run this in Quarto using a chunk to looks like the following, which was for \code{file='graphviz.dot'}.

\if{html}{\out{<div class="sourceCode">}}\preformatted{```\{dot\}
//| label: fig-doverview-graphviz
//| fig-height: 4
//| fig-cap: "Consort diagram produced with `graphviz` with detailed exclusion frequencies in a separate node"
//| file: graphviz.dot
```
}\if{html}{\out{</div>}}}
}
\value{
nothing; used to \code{knitr::knit_expand()} graphviz markup
}
\description{
Create a Quarto Graphviz dot Diagram Chunk With Variable Insertions
}
\details{
Takes a character string or vector and uses \code{\link[knitr:knit_expand]{knitr::knit_expand()}} to apply variable insertions before the diagram is rendered by Quarto.  See \href{https://hbiostat.org/rflow/doverview.html#sec-doverview-filter/}{this} for an example.  Unlike \code{mermaid}, \code{graphviz} can include user-defined linkages to specific parts of a node (e.g., a single word in a line of text) to another part of the chart, and can render tables.  If an inclusion is \code{...} is a data frame or table, it will be properly rendered inside the diagram.
}
\seealso{
\code{\link[=makemermaid]{makemermaid()}}, \code{\link[=makegvflow]{makegvflow()}}, \code{\link[=makedot]{makedot()}}
}
\author{
Frank Harrell
}
