% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics-utils.R
\name{paired_t_test}
\alias{paired_t_test}
\title{Paired samples t-test}
\usage{
paired_t_test(y1, y2, data, ...)
}
\arguments{
\item{y1}{A numeric vector of observations}

\item{y2}{A numeric vector of observations, with each value of y2 is assumed to
be paired, such as by repeated measures, the corresponding value of y1.}

\item{data}{A data frame with \code{y1} and \code{y2} as values.}

\item{...}{Additional arguments passed to \code{\link[stats:t.test]{stats::t.test()}}.}
}
\value{
A list with class "htest" as returned by \code{\link[stats:t.test]{stats::t.test()}}.
}
\description{
A wrapper to \code{\link[stats:t.test]{stats::t.test()}} with \code{paired = TRUE}.
}
\examples{
paired_t_test(y1, y2, data = pairedsleep)
}
