% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effective_functions.r
\name{loess_args}
\alias{loess_args}
\title{Make Arguments for LOESS Smooth}
\usage{
loess_args(
  method = "loess",
  formula = NULL,
  se = FALSE,
  na.rm = TRUE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE,
  span = 0.75,
  color = "black",
  linetype = 2,
  ...
)
}
\arguments{
\item{method}{Method used for the smooth, should be "loess".}

\item{formula}{Alternative formula argument}

\item{se}{Should standard error envelopes be plotted.}

\item{na.rm}{Should data be listwise deleted before calculating smooth.}

\item{orientation}{Orientation of the level}

\item{show.legend}{Should the legend be shown, included by default if aesthetics are mapped.}

\item{inherit.aes}{Should aesthetics from previous calls be inherited by the function.}

\item{span}{The span of the smoother.}

\item{color}{Color of the line.}

\item{linetype}{Line type of the line.}

\item{...}{Other arguments to be passed down.}
}
\value{
A list with arguments that can be used as input to `ggplot2::geom_smooth()`.
}
\description{
Makes arguments that serve as input to `ggplot2::geom_smooth()`.
}
