% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trialSamp.R
\name{trialSamp}
\alias{trialSamp}
\title{Evaluation of a sampled dataset within pscDesign}
\usage{
trialSamp(
  CFM,
  n0,
  n1,
  beta,
  fuTime,
  recTime,
  rec,
  nsim.psc = 750,
  burn.psc = 250
)
}
\arguments{
\item{CFM}{a Counter-Factual model}

\item{n0}{number of patients allocated to the control arm (defaults to 0 -
i.e. single arm study).}

\item{n1}{number of patients allocated to the experimental arm}

\item{beta}{the (log) HR used in the study design}

\item{fuTime}{Follow up time for the study design}

\item{recTime}{Recruitment time for the study design}

\item{rec}{a study recruitment estimate obtained using the recForcast()
function. If specified, recTime will be ignored.}

\item{nsim.psc}{number of simulations to use in psc estimation}

\item{burn.psc}{burn in to use in psc estimation}
}
\value{
The number of events as well as estimates of the posterior mean and
standard deviation
}
\description{
trialSamp evaluates a sampled dataset and returns the reuslts
}
