% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataSim.R
\name{dataSim}
\alias{dataSim}
\title{Study design using Personalised Synthetic Controls}
\usage{
dataSim(CFM, n0 = 0, n1 = 100, beta = 0, fuTime, recTime, rec = NULL)
}
\arguments{
\item{CFM}{a Counter-Factual model}

\item{n0}{number of patients allocated to the control arm (defaults to 0 -
i.e. single arm study).}

\item{n1}{number of patients allocated to the experimental arm}

\item{beta}{the (log) HR used in the study design}

\item{fuTime}{Follow up time for the study design}

\item{recTime}{Recruitment time for the study design}

\item{rec}{a study recruitment estimate obtained using the recForcast()
function. If specified, recTime will be ignored.}
}
\value{
A data frame intended for use with the CFM including covariate and
outcome data
}
\description{
pscDesign performs the simulations required to estimate the Power of a study
designed using personalised synthetic controls.
}
\details{
The datSim function simulates a dataset including sampled covariatees and
outcome data from a counterfactual model

Time parameters (fuTime, recTime) should be expressed on the same scale on
which they are specified in the Counter Factual Model.  One of recTime or rec
must be specified. If rec is specified, recTime will be ignored.
}
\examples{
gemCFM <- pscDesign::gemCFM
dataSim(gemCFM,n0=10,n1=20,beta=log(0.7),fuTime=12,recTime=12)
}
