% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{schooldata}
\alias{schooldata}
\alias{studentdata}
\title{Student data}
\format{
Two \code{data.frame}s, one with school-level data (\code{schooldata})
including treatment assignment and a second with student-level data
(\code{studentdata}).
\code{schoolata}:
\itemize{
\item {schoolid} Unique school ID variable.
\item {treatment} Was this school in the intervention group?
\item {state} State which the school is in.
\item {pct}_disadvantage Percent of student body flagged as "disadvantaged".
}
\code{studentdata}:
\itemize{
\item {id} Unique student ID.
\item {schoolid} Unique school ID variable.
\item {grade} Student's grade, 3-5.
\item {gpa} Student GPA in prior year.
\item {math} Standarized math score (out of 100).
}

An object of class \code{data.frame} with 8713 rows and 5 columns.
}
\usage{
schooldata

studentdata
}
\description{
An example of data sets stored at two levels.
}
\details{
In this hypothetical data, schools were randomly assignment to
treatment status, but the unit of analysis is students. Thus the two data
sets, one encoding school information (including treatment status) and one
encoding student information (which does not include treatment status).
}
\examples{
soec <- obs_spec(treatment ~ uoa(schoolid), data = schooldata)

# Treatment effect
mod1 <- lmitt(math ~ 1, specification = soec, data = studentdata)

# Treatment effect by grade
mod2 <- lmitt(math ~ as.factor(grade), specification = soec, data = studentdata)
}
\keyword{dataset}
\keyword{datasets}
