% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norm_zscore.R
\name{norm_zscore}
\alias{norm_zscore}
\title{Z-Score Standardization}
\usage{
norm_zscore(x, na.rm = TRUE)
}
\arguments{
\item{x}{A numeric vector.}

\item{na.rm}{Logical. Should NA values be removed during mean/sd calculation?
Default is \code{TRUE}.}
}
\value{
A numeric vector.
  If the input vector has zero variance (all values are identical),
  the function returns a centered vector (all zeros) and issues a warning.
}
\description{
Standardizes a numeric vector by centering it to have a mean of 0
and scaling it to have a standard deviation of 1.
}
\details{
Formula: \eqn{z = \frac{x - \mu}{\sigma}}
}
\examples{
# Standard usage
norm_zscore(c(1, 2, 3, 4, 5))

# Edge case: Zero variance
norm_zscore(c(5, 5, 5))
}
\references{
Han, J., Kamber, M., & Pei, J. (2011). \emph{Data mining: concepts and techniques} (3rd ed.). Morgan Kaufmann.
}
