% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norm_decimal.R
\name{norm_decimal}
\alias{norm_decimal}
\title{Decimal Scaling Normalization}
\usage{
norm_decimal(x, na.rm = TRUE)
}
\arguments{
\item{x}{A numeric vector.}

\item{na.rm}{Logical. Should NA values be ignored when determining the scaling factor?
Default is \code{TRUE}.}
}
\value{
A numeric vector with values typically in the range (-1, 1).
}
\description{
Normalizes a numeric vector by moving the decimal point of values of attribute A.
The number of decimal points moved depends on the maximum absolute value of A.
}
\details{
Formula: \eqn{x' = \frac{x}{10^j}}
where \eqn{j} is the smallest integer such that \eqn{\max(|x'|) < 1}.
}
\examples{
# Max value is 980, so j=3 (divides by 1000) -> 0.98
norm_decimal(c(10, 500, 980))

# Works with negative numbers
norm_decimal(c(-50, 50, 200))
}
\references{
Han, J., Kamber, M., & Pei, J. (2011). \emph{Data mining: concepts and techniques} (3rd ed.). Morgan Kaufmann.
}
