% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preflib.R
\name{write_preflib}
\alias{write_preflib}
\title{Write Ordinal Preference Data to PrefLib Formats}
\usage{
write_preflib(
  x,
  file = "",
  preferences_col = NULL,
  frequency_col = NULL,
  title = NULL,
  publication_date = NULL,
  modification_type = NULL,
  modification_date = NULL,
  description = NULL,
  relates_to = NULL,
  related_files = NULL
)
}
\arguments{
\item{x}{A \code{preferences} object or a \code{tibble} with a \code{preferences}-typed
column to write to file.}

\item{file}{Either a character string naming the a file or a writeable,
open connection. The empty string \code{""} will write to stdout.}

\item{preferences_col}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> When \code{x} is a
\code{tibble}, the column containing the preferences to be written to file.
If not provided and \code{x} is a \code{tibble}, then}

\item{frequency_col}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> When \code{x} is a
\code{tibble}, the column containing the frequency of the preferences. If not
provided, each row is considered to be observed a single time.}

\item{title}{The title of the data file, for instance the name of the
election represented in the data file. If not provided, we check for the
presence of \code{attr(x, "preflib")}, and if it exists we check for \code{TITLE}.}

\item{publication_date}{The date at which the data file was published for the
first time. If not provided, we check for the presence of
\code{attr(x, "preflib")}, and if it exists we check for \verb{PUBLICATION DATE}.}

\item{modification_type}{The modification type of the data: one of
\code{original}, \code{induced}, \code{imbued} or \code{synthetic} (see \code{Details}). If not
provided, we check for the presence of \code{attr(x, "preflib")}, and if it exists
we check for \verb{MODIFICATION TYPE}.}

\item{modification_date}{The last time the data was modified. If not
provided, we check for the presence of \code{attr(x, "preflib")}, and if it exists
we check for \verb{MODIFICATION DATE}.}

\item{description}{A description of the data file, providing additional
information about it. If not provided, we check for the presence of
\code{attr(x, "preflib")}, and if it exists we check for \code{DESCRIPTION}.}

\item{relates_to}{The name of the data file that the current file relates to,
typically the source file in case the current file has been derived from
another one. If not provided, we check for the presence of
\code{attr(x, "preflib")}, and if it exists we check for \verb{RELATES TO}.}

\item{related_files}{The list of all the data files related to this one,
comma separated. If not provided, we check for the presence of
\code{attr(x, "preflib")}, and if it exists we check for \verb{RELATED FILES}.}
}
\value{
No return value. Output will be written to file or stdout.
}
\description{
Write \code{preferences} to \code{.soc}, \code{.soi}, \code{.toc} or \code{.toi} file types, as
defined by the PrefLib specification:
\href{https://preflib.github.io/PrefLib-Jekyll/}{\{PrefLib\}: A Library for Preferences}.
}
\details{
The file types supported are
\describe{
\item{.soc}{Strict Orders - Complete List}
\item{.soi}{Strict Orders - Incomplete List}
\item{.toc}{Orders with Ties - Complete List}
\item{.toi}{Orders with Ties - Incomplete List}
}

The PrefLib format specification requires some additional metadata. Note
that the additional metadata required for the PrefLib specification is not
necessarily required for the \code{write_preflib} method; any missing fields
required by the PrefLib format will simply show "NA".
\describe{
\item{TITLE (required)}{
The title of the data file, for instance the year of the election
represented in the data file.
}
\item{DESCRIPTION (optional)}{
A description of the data file, providing additional information about it.
}
\item{RELATES TO (optional)}{
The name of the data file that the current file relates to, typically the
source file in case the current file has been derived from another one.
}
\item{RELATED FILES (optional)}{
The list of all the data files related to this one, comma separated.
}
\item{PUBLICATION DATE (required)}{
The date at which the data file was published for the first time.
}
\item{MODIFICATION TYPE (required)}{
The modification type of the data. One of:
\describe{
\item{original}{Data that has only been converted into a PrefLib format.}
\item{induced}{Data that has been induced from another context. For
example, computing a pairwise relation from a set of strict
total orders. No assumptions have been made to create these
files, just a change in the expression language.}
\item{imbued}{Data that has been imbued with extra information. For
example, extending an incomplete partial order by placing
all unranked candidates tied at the end.}
\item{synthetic}{Data that has been generated artificially.}
}
}
\item{MODIFICATION DATE (optional)}{
The last time the data was modified.
}
}

In addition to these fields, some required PrefLib fields will be generated
automatically depending on arguments to \code{write_preflib()} and the attributes
of the \code{aggregated_preferences} object being written to file:
\describe{
\item{FILE NAME}{The name of the output file.}
\item{DATA TYPE}{The data type (one of \code{soc}, \code{soi}, \code{toc} or \code{toi}).}
\item{NUMBER ALTERNATIVES}{The number of items.}
\item{ALTERNATIVE NAME \code{X}}{The name of each item, where \code{X} ranges from
\code{0} to \code{length(items)}.}
\item{NUMBER VOTERS}{The total number of orderings.}
\item{NUMBER UNIQUE ORDERS}{The number of distinct orderings.}
}

Note that PrefLib refers to the items as "alternatives".
The "alternatives" in the output file will be the same as the "items" in the
\code{aggregated_preferences} object.
}
