\name{ppmdat}
\alias{ppmdat}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Prepare data for model fitting}
\description{This function prepares the data for model fitting. In particular, it
determines observation weights and sets up the design matrix required for fitting
a regularisation path.}
\usage{
ppmdat(sp.xy, sp.scale, back.xy, coord = c("X","Y"), sp.dat = getEnvVar(sp.xy = sp.xy, 
env.scale = sp.scale, env.grid = back.xy, coord = coord, writefile = writefile), 
sp.file = NA, quad.file = NA, datfilename = "PPMDat", writefile = TRUE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{sp.xy}{A matrix of species locations containing at least one column representing
longitude and one column representing latitude.}
  \item{sp.scale}{The spatial resolution at which to sample quadrature points.}
  \item{back.xy}{The geo-referenced matrix of environmental grids.}
  \item{coord}{A vector containing the names of the longitude and latitude coordinates, as
in \code{\link{sampleQuad}}.}
  \item{sp.dat}{A matrix of species presence locations and the corresponding environmental
data, as generated by \code{\link{getEnvVar}}.}
  \item{sp.file}{The name of a saved file containing a matrix of species presence locations 
and the corresponding environmental data, as generated by \code{\link{getEnvVar}}.}
  \item{quad.file}{The name of a fie containing the quadrature points created from the
\code{\link{sampleQuad}} function.}
  \item{datfilename}{An optional argument containing the name of the saved file. Setting
\code{datfilename =} \code{"PPMDat"} will save a matrix \code{dat.ppm} containing the species presence
locations and quadrature points, the environmental data, as well as an indicator for whether the locations correspond to presence locations or quadrature points and the corresponding quadrature weights to the file \code{"PPMDat.RData"}.}
  \item{writefile}{A logical argument to determine whether the output should be written to a file or not. If \code{TRUE} (the default), the output will be saved with the file name as described in the \code{datfilename} argument.}
}
\details{This function will call the \code{\link{sampleQuad}} and \code{\link{getEnvVar}}
functions to generate a quadrature scheme and interpolate environmental data to presence
locations. Alternatively, the quadrature scheme may be directly supplied to the
\code{quad.file} argument, and the matrix of presence locations and associated environmental
data may be directly supplied to either the \code{sp.dat} argument (as an object in the
workspace) or to the \code{sp.file} argument (as the name of a saved file containing this
matrix).}
\value{A matrix \code{dat.ppm} with columns representing the latitude and longitude of presence
locations and quadrature points along with the associated environmental data, as well as
a column \code{Pres} indicating whether either point corresponds to a presence location or
a quadrature point, and a column \code{wt} of observation weights.}
\author{Ian W. Renner}
\seealso{
\code{\link{sampleQuad}} for generating a regular grid of quadrature points.

\code{\link{getEnvVar}} for interpolating environmental data to species presence locations.
}
\examples{
## Do not run because of NOTE Examples with CPU time > 2.5 times elapsed time
#data(BlueMountains)
#species.ppm = ppmdat(sp.xy = BlueMountains$eucalypt, back.xy = BlueMountains$env, 
#sp.scale = 1, datfilename = NA, writefile = FALSE)
}
\keyword{Quadrature}