% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-generator.R
\name{.auto_data_generator}
\alias{.auto_data_generator}
\title{Automatic Data Generator for brms + INLA Simulation (Multi-Effect Ready)}
\usage{
.auto_data_generator(
  formula,
  effect_name,
  family = gaussian(),
  family_args = list(),
  error_sd = 1,
  group_sd = 0.5,
  obs_per_group = 10,
  predictor_means = NULL,
  predictor_sds = NULL
)
}
\arguments{
\item{formula}{Model formula (may include brms-style random effects).}

\item{effect_name}{Character vector of fixed effect names to manipulate.}

\item{family}{brms family object, e.g. gaussian(), binomial().}

\item{family_args}{Named list of family-specific arguments.}

\item{error_sd}{Residual SD for Gaussian-like families.}

\item{group_sd}{SD of random effects.}

\item{obs_per_group}{Number of observations per grouping level.}

\item{predictor_means}{Named list of means for continuous predictors.}

\item{predictor_sds}{Named list of SDs for continuous predictors.}
}
\value{
Function: function(n, effect) returns a data.frame with n rows.
}
\description{
Creates a simulation function taking n (sample size) and a named effect vector/list.
Supports multiple predictors, brms-style random effects, and most GLM families.
}
\keyword{internal}
