% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.graph.R
\name{fit.graph}
\alias{fit.graph}
\title{Estimate parameters of an admixture graph}
\usage{
fit.graph(
  graph.params,
  Q.lambda = 0,
  eps.admix.prop = 1e-06,
  edge.fact = 1000,
  admix.fact = 100,
  compute.ci = F,
  drift.scaling = F,
  outfileprefix = NULL,
  verbose = TRUE
)
}
\arguments{
\item{graph.params}{An object of class graph.params containing graph information and relevant Fstats estimates (see the function generate.graph.params)}

\item{Q.lambda}{A scalar (usually small) to add to the diagonal elements of the error covariance matrix of fstats estimates (may improve numerical stability of its decomposition for large number of populations)}

\item{eps.admix.prop}{A scalar defining admixture proportion domain (eps.admix.prop vary between eps.admix.prop and 1-eps.admix.prop)}

\item{edge.fact}{The multiplying factor of edges length in graph representation}

\item{admix.fact}{The multiplying factor of admixture proportion in graph representation}

\item{compute.ci}{Derive 95\% Confidence Intervals for the parameters of the admixture graph (edge lengths and admixture rates)}

\item{drift.scaling}{If TRUE scale edge lengths in drift units (require estimates of leave heterozygosities)}

\item{outfileprefix}{The prefix of the dot file that will represent the graph (with extension ".dot"). If NULL, no graph file generated}

\item{verbose}{If TRUE extra information is printed on the terminal}
}
\value{
An object of class fitted.graph (see help(fitted.graph) for details)
}
\description{
Estimate parameters of an admixture graph
}
\details{
Let \eqn{f} represent the n-length vector of basis target (i.e., observed)  F2 and F3 statistics and \eqn{g(e;a)=X(a)*e} the vector of their expected values given the vector of graph edges lengths \eqn{e} and the incidence matrix \eqn{X(a)} that depends on the structure of the graph and the admixture rates \eqn{a} (if there is no admixture in the graph, \eqn{X(a)} only contains 0 or 1). The function attempts to find the  \eqn{e} and \eqn{a} graph parameter values that minimize a cost (score of the model) defined as \eqn{S(e;a)=(f-g(e;a))'Q^{-1}(f-g(e;a))}. Assuming \eqn{f~N(g(e;a),Q)} (i.e., the observed f-statistics vector is multivariate normal distributed around an expected g vector specified by the admixture graph and a covariance structure empirically estimated), \eqn{S=-2log(L) - K} where \eqn{L} is the likelihood of the fitted graph and \eqn{K=n*log(2*pi)+log(|Q|)}. Also, for model comparison purpose, a standard \eqn{BIC} is then derived from \eqn{S} as \eqn{BIC= S + p*log(n) - K} (p being the number of graph parameters, i.e., edge lengths and admixture rates). 
As mentioned by Patterson et al. (2012), the score \eqn{S(e;a)} is quadratic in edge lengths \eqn{e} given \eqn{a}. The function uses the Lawson-Hanson non-negative linear least squares algorithm implemented in the nnls function (package nnls) to estimate \eqn{e} (subject to the constraint of positive edge lengths) by finding the vector \eqn{e} that minimize \eqn{S(e;a)=(f-X(a)*e)'Q^{-1}(f-X(a)*e)=||G*f-G*X(a)*e||} (where \eqn{G} results from the Cholesky decomposition of \eqn{Q^{-1}}, i.e., \eqn{Q^{-1}=G'G}). Note that the *Q.lambda* argument may be used to add a small constant (e.g., \eqn{1e-4}) to the diagonal elements of \eqn{Q} to avoid numerical problems (see Patterson et al., 2012). Yet *Q.lambda* is always disregarded when computing the final score \eqn{S} and \eqn{BIC}. Minimization of \eqn{S(e;a)} is thus reduced to the identification of the admixture rates (\eqn{a} vector) which is performed using the L-BFGS-B  method (i.e., Limited-memory Broyden-Fletcher-Goldfarb-Shanno algorithm with box constraints) implemented in the optim function (stats package). The *eps.admix.prop* argument allows specifying the lower and upper bound of the admixture rates to *eps.admix.prop* and *1-eps.admix.prop* respectively.
Scaling of the edges lengths in drift units (i.e., in units of \eqn{t/2N} where \eqn{t} is time in generations and \eqn{N} is the effective population size) is performed as described in Lipson et al. (MBE, 2013) by dividing the estimated edges lengths by half the estimated heterozygosity of their parental nodes (using the property \eqn{hp=hc+2e(C,P)} where \eqn{hp} and \eqn{hc} are the heterozygosities of a child C and its parent P node and \eqn{e(C,P)} is the estimated length of the branch relating C and P.
Finally, if compute.ci=TRUE, a (rough) \eqn{95\%} confidence intervals is computed using a bisection method (with a \eqn{1e-4} precision) for each parameters in turn (all others being set to their estimated value). Note that \eqn{95\%} CI are here defined as the set of values associated to a score \eqn{S} such that \eqn{Sopt<S<Sopt+3.84} (where \eqn{Sopt} is the optimized score), i.e., with a likelihood-ratio test statistic with respect to the fitted values \eqn{<3.84} (the \eqn{95\%} threshold of a one ddl Chi-square distribution).
}
\seealso{
To generate a graph.params object, see \code{\link{generate.graph.params}}. The fitted graph may be plotted directly using plot that calls grViz() function and the resulting fitted fstats may be compared to the estimated ones with \code{\link{compare.fitted.fstats}}.
}
