% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_server_yml.R
\name{create_server_yml}
\alias{create_server_yml}
\title{Create a _server.yml file to describe your API}
\usage{
create_server_yml(..., path = ".", constructor = NULL, freeze_opt = TRUE)
}
\arguments{
\item{...}{path to files and/or directories that contain annotated plumber
files to be used by your API}

\item{path}{The folder to place the generated \verb{_server.yml} file in}

\item{constructor}{The path to a file that creates a plumber2 API object. Can
be omitted in which case an API object will be created for you}

\item{freeze_opt}{Logical specifying whether any options you currently have
locally (either as environment variables or R options) should be written to
the \verb{_server.yml} file. Shared secret will never be written to the file and
you must find a different way to move that to your deployment server.}
}
\description{
While you can manually create a plumber2 API by calling \code{\link[=api]{api()}}, you will
often need to deploy the api somewhere else. To facilitate this you can
create a \verb{_server.yml} that encapsulates all of your settings and plumber
files. If you call \code{\link[=api]{api()}} with a path to such a file the API will be
constructed according to its content.
}
\examples{
\dontshow{if (FALSE) withAutoprint(\{ # examplesIf}
create_server_yml(
  "path/to/a/plumber/file.R"
)
\dontshow{\}) # examplesIf}
}
