% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggtern.R
\name{stat_field3logit}
\alias{stat_field3logit}
\title{Add a field to a \code{gg3logit} plot}
\usage{
stat_field3logit(
  mapping = aes(),
  data = NULL,
  geom = "segment",
  position = "identity",
  show.legend = NA,
  inherit.aes = TRUE,
  arrow. = arrow(length = unit(0.2, "cm")),
  ...
)
}
\arguments{
\item{mapping}{list of aesthetic mappings to be used for plot. Mandatory
aesthetics should not be specified if \code{field3loglit} or \code{multifield3logit}
object is passed to \code{data}. See secion \strong{Aesthetic mappings} of
\code{\link[=gg3logit]{gg3logit()}} for details.}

\item{data}{a \code{field3logit} object, a \code{multifield3logit} object, or
a \code{data.frame} structured like a fortified \code{field3logit} or a
\code{multifield3logit} object.}

\item{geom}{The geometric object to use to display the data for this layer.
When using a \verb{stat_*()} function to construct a layer, the \code{geom} argument
can be used to override the default coupling between stats and geoms. The
\code{geom} argument accepts the following:
\itemize{
\item A \code{Geom} ggproto subclass, for example \code{GeomPoint}.
\item A string naming the geom. To give the geom as a string, strip the
function name of the \code{geom_} prefix. For example, to use \code{geom_point()},
give the geom as \code{"point"}.
\item For more information and other ways to specify the geom, see the
\link[ggplot2:layer_geoms]{layer geom} documentation.
}}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display. To include legend keys for all levels, even
when no data exists, use \code{TRUE}.  If \code{NA}, all levels are shown in legend,
but unobserved levels are omitted.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:annotation_borders]{annotation_borders()}}.}

\item{arrow.}{specification for arrow heads, as created by
function \code{\link[grid:arrow]{arrow}} of package \code{\link[grid:grid-package]{grid}}.}

\item{...}{additional arguments passed through to \code{\link[ggtern:ggtern]{ggtern}}.}
}
\value{
Layer of \code{ggplot2} package, object of class \code{LayerInstance}.
}
\description{
\code{\link[=stat_field3logit]{stat_field3logit()}} adds a field to a \code{\link{gg3logit}} plot.
}
\examples{
\donttest{
data(cross_1year)

mod0 <- nnet::multinom(employment_sit ~ gender + finalgrade, data = cross_1year)
field0 <- field3logit(mod0, 'genderFemale', conf = 0.95)

gg3logit(field0) + stat_field3logit()
gg3logit(field0) + stat_field3logit() + stat_conf3logit()
}

}
\seealso{
Other gg functions: 
\code{\link{autoplot.Hfield3logit}()},
\code{\link{gg3logit}()},
\code{\link{stat_3logit}()},
\code{\link{stat_conf3logit}()}
}
\concept{gg functions}
