% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic_5pl.R
\name{logistic_5pl}
\alias{logistic_5pl}
\title{5PL Logistic Dose-Response Model (Emax/Imax, Asymmetric)}
\arguments{
\item{data}{A data frame containing dose-response experimental data.}

\item{dose_col}{Character string specifying the column name for dose.}

\item{response_col}{Character string specifying the column name for measured response.}

\item{group_col}{Optional character string specifying a column for grouping.}

\item{log_dose}{Logical; if TRUE, dose values are log10-transformed for plotting.}

\item{plot}{Logical; if TRUE, generates a dose-response plot with fitted 5PL curves.}

\item{annotate}{Logical; if TRUE, annotates the plot with model parameters and fit metrics.}
}
\value{
A list containing:
\describe{
  \item{\code{fitted_parameters}}{Data frame with E_min, E_max, EC50, n, s, RMSE, AIC, and BIC for each group.}
  \item{\code{data}}{Processed data used for fitting and plotting.}
}
}
\description{
Fits pharmacodynamic dose-response data to a 5-parameter logistic (5PL) model
using nonlinear least squares regression.

The model can handle **both increasing (Stimulatory / Emax)** and
**decreasing (Inhibitory / Imax)** dose-response curves automatically.

The 5PL model extends 4PL by adding an asymmetry factor \eqn{s}:

\deqn{
  E = E_{min} + \frac{E_{max} - E_{min}}{(1 + (EC_{50} / D)^n)^s} \quad \text{for increasing curves}
}

\deqn{
  E = E_{min} + \frac{E_{max} - E_{min}}{(1 + (D / IC_{50})^n)^s} \quad \text{for decreasing curves}
}

Key features:
* Automatically detects increasing vs decreasing responses
* \eqn{E_{min}} = minimum response (floor)
* \eqn{E_{max}} = maximum response (ceiling)
* \eqn{EC_{50}/IC_{50}} = dose producing half-maximal effect
* \eqn{n} = Hill coefficient (steepness)
* \eqn{s} = asymmetry factor (skew)
* Skewed sigmoidal curve; reduces bias when the rising and falling slopes are
  not symmetric around EC50
}
\examples{
# Example I: Single increasing curve (Emax)
df_emax_5pl <- data.frame(
  dose = c(0.1, 0.3, 1, 3, 10, 30, 100),
  response = c(5, 12, 28, 55, 75, 90, 98)
)
logistic_5pl(
  data = df_emax_5pl,
  dose_col = "dose",
  response_col = "response"
)

# Example II: Single decreasing curve (Imax)
df_imax_5pl <- data.frame(
  dose = c(0.1, 0.3, 1, 3, 10, 30, 100),
  response = c(95, 88, 70, 50, 30, 15, 5)
)
logistic_5pl(
  data = df_imax_5pl,
  dose_col = "dose",
  response_col = "response"
)

# Example III: Two treatment groups, mixed Emax/Imax
df_groups_5pl <- data.frame(
  dose = rep(c(0.1, 0.3, 1, 3, 10, 30), 2),
  response = c(
    4, 10, 25, 55, 78, 92,   # Group A: increasing (Emax)
    90, 75, 55, 35, 20, 10   # Group B: decreasing (Imax)
  ),
  treatment = rep(c("Group A", "Group B"), each = 6)
)
logistic_5pl(
  data = df_groups_5pl,
  dose_col = "dose",
  response_col = "response",
  group_col = "treatment",
  log_dose = TRUE
)
}
\references{
Richards, F. J. (1959) <doi:10.1093/jxb/10.2.290> A flexible growth
function for empirical use. Journal of Experimental Botany, 10(2), 290–301.
}
\author{
Paul Angelo C. Manlapaz
}
