% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function-names.R
\name{pkgstats_fn_names}
\alias{pkgstats_fn_names}
\title{Extract names of all functions for one R package}
\usage{
pkgstats_fn_names(path)
}
\arguments{
\item{path}{Either a path to a local source repository, or a local '.tar.gz'
file, containing code for an R package.}
}
\value{
A \code{data.frame} with three columns:
\itemize{
\item package: Name of package
\item version: Package version
\item fn_name: Name of function
}
}
\description{
Extract names of all functions for one R package
}
\examples{
# 'path' can be path to a package tarball:
f <- system.file ("extdata", "pkgstats_9.9.tar.gz", package = "pkgstats")
path <- extract_tarball (f)
s <- pkgstats_fn_names (path)
}
\seealso{
Other misc: 
\code{\link{extract_tarball}()}
}
\concept{misc}
