% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pix_transaction_stats.R
\name{get_pix_transaction_stats}
\alias{get_pix_transaction_stats}
\title{Get PIX Transaction Statistics}
\usage{
get_pix_transaction_stats(
  database,
  filter = NULL,
  columns = NULL,
  top = NULL,
  skip = NULL,
  orderby = NULL,
  verbose = TRUE
)
}
\arguments{
\item{database}{Character string in "YYYYMM" format specifying which month's
data to retrieve. This parameter is \strong{required}.}

\item{filter}{OData filter expression as a character string. Examples:
\itemize{
\item \code{"NATUREZA eq 'P2P'"} - Filter by transaction nature
\item \code{"PAG_REGIAO eq 'SUDESTE'"} - Filter by payer region
\item \code{"FORMAINICIACAO eq 'DICT'"} - Filter by initiation method
}}

\item{columns}{Character vector of columns to return. If NULL, returns all
columns. See "Available Columns" section.}

\item{top}{Integer; maximum number of records to return.}

\item{skip}{Integer; number of records to skip (for pagination).}

\item{orderby}{Character string specifying the column to sort by. Use
\code{"Column"} for ascending or \code{"Column desc"} for descending order.}

\item{verbose}{Logical; if TRUE (default), prints progress messages.}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with PIX transaction statistics.
}
\description{
Retrieves detailed statistics on PIX transactions settled through the
Instant Payment System (SPI), with breakdowns by payer/receiver type,
region, age group, initiation method, and transaction nature.
}
\details{
The BCB PIX API requires a \code{database} parameter specifying which month's
data to retrieve. The data provides granular breakdowns of PIX transactions.
\subsection{Transaction Nature Codes}{
\itemize{
\item \strong{P2P}: Person to Person
\item \strong{P2B}: Person to Business
\item \strong{B2P}: Business to Person
\item \strong{B2B}: Business to Business
\item \strong{P2G}: Person to Government
\item \strong{G2P}: Government to Person
}
}

\subsection{Initiation Methods}{
\itemize{
\item \strong{DICT}: PIX Key lookup
\item \strong{QRDN}: Dynamic QR Code
\item \strong{QRES}: Static QR Code
\item \strong{MANU}: Manual entry (bank details)
\item \strong{INIC}: Payment Initiator
}
}
}
\section{Available Columns}{

\describe{
\item{AnoMes}{Reference year-month as integer (YYYYMM format)}
\item{PAG_PFPJ}{Payer type: PF (Individual) or PJ (Legal Entity)}
\item{REC_PFPJ}{Receiver type: PF (Individual) or PJ (Legal Entity)}
\item{PAG_REGIAO}{Payer region (NORTE, NORDESTE, SUDESTE, SUL, CENTRO-OESTE)}
\item{REC_REGIAO}{Receiver region}
\item{PAG_IDADE}{Payer age group}
\item{REC_IDADE}{Receiver age group}
\item{FORMAINICIACAO}{Initiation method (DICT, QRDN, QRES, MANU, INIC)}
\item{NATUREZA}{Transaction nature (P2P, P2B, B2P, B2B, P2G, G2P)}
\item{FINALIDADE}{Transaction purpose (Pix, Pix Saque, Pix Troco, etc.)}
\item{VALOR}{Total transaction value (in BRL)}
\item{QUANTIDADE}{Number of transactions}
}
}

\examples{
\donttest{# It usually takes much longer than 5 seconds.
# Get transaction statistics for September 2025
stats <- get_pix_transaction_stats(database = "202509")

# Filter by transaction nature
p2p <- get_pix_transaction_stats(
  database = "202509",
  filter = "NATUREZA eq 'P2P'"
)

# Filter by region and order by value
sudeste <- get_pix_transaction_stats(
  database = "202509",
  filter = "PAG_REGIAO eq 'SUDESTE'",
  orderby = "VALOR desc",
  top = 100
)

# Multiple filters (use 'and')
filtered <- get_pix_transaction_stats(
  database = "202509",
  filter = "NATUREZA eq 'P2P' and PAG_REGIAO eq 'NORDESTE'"
)
}
}
