% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pix_transaction_stats.R
\name{get_pix_summary}
\alias{get_pix_summary}
\title{Get PIX Transaction Summary}
\usage{
get_pix_summary(database, group_by = "NATUREZA", verbose = TRUE)
}
\arguments{
\item{database}{Character string in "YYYYMM" format specifying which month's
data to retrieve. This parameter is \strong{required}.}

\item{group_by}{Character vector of columns to group by. Common choices:
"NATUREZA", "PAG_REGIAO", "REC_REGIAO", "FORMAINICIACAO".}

\item{verbose}{Logical; if TRUE (default), prints progress messages.}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with aggregated transaction statistics.
}
\description{
Retrieves transaction statistics and aggregates them by specified grouping
variables. This is a convenience function that fetches data and performs
common aggregations.
}
\examples{
\donttest{# It usually takes much longer than 5 seconds.
# Summary by transaction nature
get_pix_summary(database = "202509", group_by = "NATUREZA")

# Summary by payer region
get_pix_summary(database = "202509", group_by = "PAG_REGIAO")

# Summary by nature and initiation method
get_pix_summary(database = "202509", group_by = c("NATUREZA", "FORMAINICIACAO"))
}
}
