% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_aggregation_structure.R
\name{as_aggregation_structure}
\alias{as_aggregation_structure}
\alias{as_aggregation_structure.default}
\alias{as_aggregation_structure.data.frame}
\alias{as_aggregation_structure.matrix}
\title{Coerce to an aggregation structure}
\usage{
as_aggregation_structure(x, ...)

\method{as_aggregation_structure}{default}(x, ..., weights = NULL)

\method{as_aggregation_structure}{data.frame}(x, ...)

\method{as_aggregation_structure}{matrix}(x, ...)
}
\arguments{
\item{x}{An object to coerce into an aggregation structure.}

\item{...}{Further arguments passed to or used by methods.}

\item{weights}{A numeric vector of aggregation weights for the elementary
aggregates. The default is to give each elementary aggregate the same
weight.}
}
\value{
A price index aggregation structure that inherits from
\code{\link{piar_aggregation_structure}}.
}
\description{
Coerce an object into an aggregation structure object.
}
\details{
The default method attempts to coerce \code{x} into a list prior to calling
\code{\link[=aggregation_structure]{aggregation_structure()}}.

The data frame and matrix methods treat \code{x} as a table with a row for
each elementary aggregate, a column of labels for each level in the
aggregation structure, and a column of weights for the elementary aggregates.
}
\examples{
# A simple aggregation structure
#            1
#      |-----+-----|
#      11          12
#  |---+---|       |
#  111     112     121
#  (1)     (3)     (4)

aggregation_weights <- data.frame(
  level1 = c("1", "1", "1"),
  level2 = c("11", "11", "12"),
  ea     = c("111", "112", "121"),
  weight = c(1, 3, 4)
)

pias <- aggregation_structure(
  aggregation_weights[1:3],
  weights = aggregation_weights[[4]]
)

all.equal(
  pias,
  as_aggregation_structure(aggregation_weights)
)

all.equal(
  pias,
  as_aggregation_structure(as.matrix(aggregation_weights))
)

}
\seealso{
\code{\link[=as.matrix.piar_aggregation_structure]{as.matrix()}} and
\code{\link[=as.data.frame.piar_aggregation_structure]{as.data.frame()}} for
coercing an aggregation structure into a tabular form.
}
