% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/squash.R
\name{squash}
\alias{squash}
\alias{phint_squash}
\alias{datetime_squash}
\title{Squash overlapping intervals into non-overlapping spans}
\usage{
phint_squash(
  phint,
  by = NULL,
  na.rm = TRUE,
  empty_to = c("hole", "na", "empty"),
  order_by = FALSE,
  keep_by = FALSE
)

datetime_squash(
  start,
  end,
  by = NULL,
  na.rm = TRUE,
  empty_to = c("hole", "na", "empty"),
  order_by = FALSE,
  keep_by = FALSE
)
}
\arguments{
\item{phint}{\verb{[phinterval / Interval]}

A \verb{<phinterval>} or \verb{<Interval>} vector.}

\item{by}{\verb{[vector / data.frame / NULL]}

An optional grouping vector or data frame. When provided, intervals are
grouped by \code{by} and merged separately within each group. If \code{NULL} (the
default), all intervals are merged into a single phinterval element.

For \code{datetime_squash()}, \code{by} must be recyclable with the recycled length
of \code{start} and \code{end}.

\code{by} may be any vector in the vctrs sense. See \code{\link[vctrs:vector-checks]{vctrs::obj_is_vector()}}
for details.}

\item{na.rm}{\verb{[TRUE / FALSE]}

Should \code{NA} elements be removed before squashing? If \code{FALSE} and any \code{NA}
elements are present, the result for that group is \code{NA}. Defaults to \code{TRUE}.}

\item{empty_to}{\verb{["hole" / "na" / "empty"]}

How to handle empty inputs (length-0 vectors or groups with only \code{NA} values
when \code{na.rm = TRUE}):
\itemize{
\item \code{"hole"} (default): Return a hole
\item \code{"na"}: Return an \code{NA} phinterval
\item \code{"empty"}: Return a length-0 phinterval vector
}}

\item{order_by}{\verb{[TRUE / FALSE]}

Should the output be ordered by the values in \code{by}? If \code{FALSE} (the default),
the output order matches the first appearance of each group in \code{by}. If \code{TRUE},
the output is sorted by the unique values of \code{by}. Only used when \code{by} is not
\code{NULL}.}

\item{keep_by}{\verb{[TRUE / FALSE]}

Should the \code{by} values be returned alongside the result? If \code{FALSE} (the
default), returns a \verb{<phinterval>} vector. If \code{TRUE}, returns a \code{\link[tibble:tibble]{tibble::tibble()}}
with columns \code{by} and \code{phint}. Requires \code{by} to be non-\code{NULL}.}

\item{start}{\verb{[POSIXct / POSIXlt / Date]}

A vector of start times. Must be recyclable with \code{end}. Only used in
\code{datetime_squash()}.}

\item{end}{\verb{[POSIXct / POSIXlt / Date]}

A vector of end times. Must be recyclable with \code{start}. Only used in
\code{datetime_squash()}.}
}
\value{
When \code{keep_by = FALSE}:
\itemize{
\item If \code{by = NULL}: A length-1 \verb{<phinterval>} vector (or length-0 if the input
is empty and \code{empty_to = "empty"})
\item If \code{by} is provided: A \verb{<phinterval>} vector with one element per unique
value of \code{by}
}

When \code{keep_by = TRUE}: A \code{\link[tibble:tibble]{tibble::tibble()}} with columns \code{by} and \code{phint}.
}
\description{
\code{phint_squash()} and \code{datetime_squash()} merge overlapping or adjacent
intervals into a minimal set of non-overlapping, non-adjacent time spans.
\itemize{
\item \code{phint_squash()} takes a \verb{<phinterval>} or \verb{<Interval>} vector
\item \code{datetime_squash()} takes separate \code{start} and \code{end} datetime vectors
}

When \code{by = NULL} (the default), all intervals are merged into a single
phinterval element. When \code{by} is provided, intervals are grouped and merged
separately within each group, creating one phinterval element per unique
value of \code{by}.
}
\details{
These functions are particularly useful in aggregation workflows with
\code{\link[dplyr:summarise]{dplyr::summarize()}} to combine intervals within groups.
}
\examples{
jan_1_to_5 <- interval(as.Date("2000-01-01"), as.Date("2000-01-05"))
jan_3_to_9 <- interval(as.Date("2000-01-03"), as.Date("2000-01-09"))
jan_11_to_12 <- interval(as.Date("2000-01-11"), as.Date("2000-01-12"))

# phint_squash: merge intervals from a phinterval/Interval vector
phint_squash(c(jan_1_to_5, jan_3_to_9, jan_11_to_12))

# datetime_squash: merge intervals from start/end vectors
datetime_squash(
  start = as.Date(c("2000-01-01", "2000-01-03", "2000-01-11")),
  end = as.Date(c("2000-01-05", "2000-01-09", "2000-01-12"))
)

# NA values are removed by default
phint_squash(c(jan_1_to_5, jan_3_to_9, jan_11_to_12, NA))

# Set na.rm = FALSE to propagate NA values
phint_squash(c(jan_1_to_5, jan_3_to_9, jan_11_to_12, NA), na.rm = FALSE)

# Squash within groups
phint_squash(
  c(jan_1_to_5, jan_3_to_9, jan_11_to_12),
  by = c(1, 1, 2)
)

# Return a data frame with by values
phint_squash(
  c(jan_1_to_5, jan_3_to_9, jan_11_to_12),
  by = c("A", "A", "B"),
  keep_by = TRUE
)

# Control output order with order_by
phint_squash(
  c(jan_1_to_5, jan_3_to_9, jan_11_to_12),
  by = c(2, 2, 1),
  order_by = TRUE
)

# empty_to determines the result of empty inputs
empty <- phinterval()
phint_squash(empty, empty_to = "hole")
phint_squash(empty, empty_to = "na")
phint_squash(empty, empty_to = "empty")

}
