% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pguFilter.R
\name{pgu.filter}
\alias{pgu.filter}
\title{pgu.filter}
\format{
[R6::R6Class] object.
}
\description{
Filter the pguIMP dataset.
}
\details{
The filtering is done by column and row indices.
This object is used by the shiny based gui and is not for use in individual R-scripts!
}
\author{
Sebastian Malkusch
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{colIdx}}{Returns the instance variable colIdx
(numeric)}

\item{\code{setColIdx}}{Sets the instance variable colIdx
(numeric)}

\item{\code{rowIdx}}{Returns the instance variable rowIdx
(numeric)}

\item{\code{setRowIdx}}{Sets the instance variable rowIdx
(numeric)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-pgu.filter-new}{\code{pgu.filter$new()}}
\item \href{#method-pgu.filter-print}{\code{pgu.filter$print()}}
\item \href{#method-pgu.filter-reset}{\code{pgu.filter$reset()}}
\item \href{#method-pgu.filter-predict}{\code{pgu.filter$predict()}}
\item \href{#method-pgu.filter-clone}{\code{pgu.filter$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.filter-new"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.filter-new}{}}}
\subsection{Method \code{new()}}{
Resets the filter parameter colIdx to the full dataframe.


Resets the filter parameter rowIdx to the full dataframe.


Clears the heap and
indicates that instance of pguIMP::pgu.filter is removed from heap.


Creates and returns a new pguIMP::pgu.filter object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.filter$new(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{The data to be analyzed.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new pguIMP::pgu.filter object.
(pguIMP::pgu.filter)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.filter-print"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.filter-print}{}}}
\subsection{Method \code{print()}}{
Prints instance variables of a pguIMP::pgu.filter object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.filter$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
string
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.filter-reset"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.filter-reset}{}}}
\subsection{Method \code{reset()}}{
Resets the filter parameter colIdx and rowIdx to the full dataframe.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.filter$reset(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{The data to be analyzed.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.filter-predict"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.filter-predict}{}}}
\subsection{Method \code{predict()}}{
Filters and returns the given data frame.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.filter$predict(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{The data to be analyzed.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The filtered data frame
(tibble::tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.filter-clone"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.filter-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.filter$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
