% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pm_explore.R
\name{pm_list_endemic}
\alias{pm_list_endemic}
\title{List endemic mammal species by taxonomic order}
\usage{
pm_list_endemic(include_rate = FALSE)
}
\arguments{
\item{include_rate}{Logical. If \code{TRUE}, includes additional columns
showing total species richness and endemism rate for each order.
Default is \code{FALSE}.}
}
\value{
A tibble with one row per order containing endemic species,
arranged in descending order by number of endemic species, with the
following columns:
\describe{
\item{order}{Taxonomic order}
\item{n_families}{Number of families with endemic species in the order}
\item{n_genera}{Number of genera with endemic species in the order}
\item{n_endemic}{Number of endemic species in the order}
\item{n_species}{(Only if \code{include_rate = TRUE}) Total number of
species in the order}
\item{endemic_rate}{(Only if \code{include_rate = TRUE}) Proportion of
endemic species (0-1)}
\item{endemic_pct}{(Only if \code{include_rate = TRUE}) Percentage of
endemic species (0-100)}
}
}
\description{
Summarises the diversity of endemic mammal species in Peru, grouped by
taxonomic order. Provides counts of families, genera, and species that
are endemic to Peru within each order. Optionally includes endemism rates
relative to total species richness.
}
\details{
This function focuses exclusively on species that are endemic to Peru
(i.e., species found nowhere else in the world). Orders without any
endemic species are not included in the output.

When \code{include_rate = FALSE} (default), results are sorted by the
number of endemic species in descending order, highlighting which orders
have the highest endemic diversity.

When \code{include_rate = TRUE}, results are sorted by total species
richness in descending order, and include endemism rates to show what
proportion of each order's diversity is endemic to Peru. A summary row
labeled "Total" is appended to show overall statistics.
}
\examples{
# Summary of endemic species by order
pm_list_endemic()

# Include endemism rates
pm_list_endemic(include_rate = TRUE)


}
