% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadablePlot.R
\name{downloadablePlotUI}
\alias{downloadablePlotUI}
\title{downloadablePlot module UI function}
\usage{
downloadablePlotUI(
  id,
  downloadtypes = c("png"),
  download_hovertext = NULL,
  width = "100\%",
  height = "400px",
  btn_halign = "right",
  btn_valign = "bottom",
  btn_overlap = TRUE,
  clickOpts = NULL,
  hoverOpts = NULL,
  brushOpts = NULL
)
}
\arguments{
\item{id}{character id for the object}

\item{downloadtypes}{vector of values for download types}

\item{download_hovertext}{download button tooltip hover text}

\item{width}{plot width (any valid css size value)}

\item{height}{plot height (any valid css size value)}

\item{btn_halign}{horizontal position of the download button ("left", "center", "right")}

\item{btn_valign}{vertical position of the download button ("top", "bottom")}

\item{btn_overlap}{whether the button should appear on top of the bottom of
the plot area to save on vertical space \emph{(there is often a blank area
where a button can be overlayed instead of utilizing an entire horizontal
row for the button below the plot area)}}

\item{clickOpts}{NULL or an object created by the \link[shiny]{clickOpts} function}

\item{hoverOpts}{NULL or an object created by the \link[shiny]{hoverOpts} function}

\item{brushOpts}{NULL or an object created by the \link[shiny]{brushOpts} function}
}
\value{
list of downloadFileButton UI and plot object
}
\description{
Creates a custom plot output that is paired with a linked downloadFile
button.  This module is compatible with ggplot2, grob and lattice
produced graphics.
}
\details{
downloadFile button will be hidden if \code{downloadablePlot} parameter \code{downloadfxns} or
\code{downloadablePlotUI} parameter \code{downloadtypes} is empty
}
\section{Example}{

\code{downloadablePlotUI("myplotID", c("png", "csv"),
"Download Plot or Data", "300px")}
}

\section{Notes}{

When there is nothing to download in any of the linked downloadfxns the
button will be hidden as there is nothing to download.

This module is NOT compatible with the built-in (base) graphics \emph{(such as
basic plot, etc.)} because they cannot be saved into an object and are directly
output by the system at the time of creation.
}

\section{Shiny Usage}{

Call this function at the place in ui.R where the plot should be placed.

Paired with a call to \code{downloadablePlot(id, ...)}
in server.R
}

\examples{
if (interactive()) {
  library(shiny)
  library(ggplot2)
  library(periscope2)
  shinyApp(ui = fluidPage(fluidRow(column(width = 12,
     downloadablePlotUI("object_id1",
                        downloadtypes      = c("png", "csv"),
                        download_hovertext = "Download plot and data",
                        height             = "500px",
                        btn_halign         = "left")))),
    server = function(input, output) {
      download_plot <- function() {
        ggplot(data = mtcars, aes(x = wt, y = mpg)) +
        geom_point(aes(color = cyl)) +
        theme(legend.justification   = c(1, 1),
              legend.position.inside = c(1, 1),
              legend.title           = element_blank()) +
        ggtitle("GGPlot Example ") +
        xlab("wt") +
        ylab("mpg")
      }
      downloadablePlot(id           = "object_id1",
                       logger       = "",
                       filenameroot = "mydownload1",
                       downloadfxns = list(png = download_plot, csv = reactiveVal(mtcars)),
                       aspectratio  = 1.33,
                       visibleplot  = download_plot)
  })
}

}
\seealso{
\link[periscope2]{downloadablePlot}

\link[periscope2]{downloadFileButton}

\link[shiny]{clickOpts}

\link[shiny]{hoverOpts}

\link[shiny]{brushOpts}

\link[periscope2]{appResetButton}

\link[periscope2]{appReset}

\link[periscope2]{downloadFile}

\link[periscope2]{downloadFile_ValidateTypes}

\link[periscope2]{downloadFile_AvailableTypes}

\link[periscope2]{downloadableTable}

\link[periscope2]{logViewerOutput}
}
