% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/platt.R
\name{platt_generate_regression_ETR_II}
\alias{platt_generate_regression_ETR_II}
\title{Platt Regression for ETR II}
\usage{
platt_generate_regression_ETR_II(
  data,
  alpha_start_value = platt_default_start_value_alpha,
  beta_start_value = platt_default_start_value_beta,
  ps_start_value = platt_default_start_value_ps
)
}
\arguments{
\item{data}{A \code{data.table} from from read function (e.g.\code{read_dual_pam_data}).}

\item{alpha_start_value}{Numeric. Initial value for \eqn{\alpha}. Default: \code{alpha_start_value_platt_default}.}

\item{beta_start_value}{Numeric. Initial value for \eqn{\beta}. Default: \code{beta_start_value_platt_default}.}

\item{ps_start_value}{Numeric. Initial value for \eqn{P_s}. Default: \code{ps_start_value_platt_default}.}
}
\value{
A list containing:
\itemize{
  \item \code{etr_regression_data}: Predicted ETR values.
  \item \code{residual_sum_of_squares}: Difference between observed and predicted ETR values, expressed as the sum of squared residuals.
  \item \code{root_mean_squared_error}: Difference between observed and predicted ETR values, expressed as the root mean squared error.
  \item \code{relative_root_mean_squared_error}: Difference between observed and predicted ETR values, expressed as the relative root mean squared error, normalized by the mean.
  \item \code{ps}: Maximum electron transport rate without photoinhibition (\eqn{P_s}).
  \item \code{alpha}: Initial slope of the light curve (\eqn{\alpha}).
  \item \code{beta}: Photoinhibition (\eqn{\beta}).
  \item \code{pm}: Maximum electron transport rate with photoinhibition (\eqn{P_m}).
  \item \code{ik}: Transition PAR with photoinhibition (\eqn{I_k}).
  \item \code{is}: Transition PAR without photoinhibition (\eqn{I_s}).
  \item \code{im}: PAR at maximum ETR with photoinhibition (\eqn{I_m}).
  \item \code{ib}: (\eqn{I_b})
}
}
\description{
Fits the Platt (1980) regression model using original naming conventions.
}
\details{
A detailed documentation can be found under \url{https://github.com/biotoolbox/pam?tab=readme-ov-file#platt_generate_regression_etr_i-and-platt_generate_regression_etr_ii}.
}
\examples{
path <- file.path(system.file("extdata", package = "pam"), "20240925.csv")
data <- read_dual_pam_data(path)

result <- platt_generate_regression_ETR_II(data)

}
\references{
{
  Platt, T., Gallegos, C. L., & Harrison, W. G. (1980). \emph{Photoinhibition of photosynthesis in natural assemblages of marine phytoplankton.}
  \emph{Journal of Marine Research, 38}(4). Retrieved from \url{https://elischolar.library.yale.edu/journal_of_marine_research/1525/}.

}
}
