% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openai_live.R
\name{submit_openai_pairs_live}
\alias{submit_openai_pairs_live}
\title{Live OpenAI comparisons for a tibble of pairs}
\usage{
submit_openai_pairs_live(
  pairs,
  model,
  trait_name,
  trait_description,
  prompt_template = set_prompt_template(),
  endpoint = c("chat.completions", "responses"),
  api_key = NULL,
  verbose = TRUE,
  status_every = 1,
  progress = TRUE,
  include_raw = FALSE,
  ...
)
}
\arguments{
\item{pairs}{Tibble or data frame with at least columns \code{ID1},
\code{text1}, \code{ID2}, \code{text2}. Typically created by
\code{\link{make_pairs}}, \code{\link{sample_pairs}}, and
\code{\link{randomize_pair_order}}.}

\item{model}{OpenAI model name (for example "gpt-4.1", "gpt-5.1").}

\item{trait_name}{Trait name to pass to \code{openai_compare_pair_live}.}

\item{trait_description}{Trait description to pass to
\code{openai_compare_pair_live}.}

\item{prompt_template}{Prompt template string, typically from
\code{\link{set_prompt_template}}.}

\item{endpoint}{Which OpenAI endpoint to target. One of
\code{"chat.completions"} or \code{"responses"}.}

\item{api_key}{Optional OpenAI API key.}

\item{verbose}{Logical; if TRUE, prints status, timing, and result summaries.}

\item{status_every}{Integer; print status / timing for every
\code{status_every}-th pair. Defaults to 1 (every pair). Errors are always
printed.}

\item{progress}{Logical; if TRUE, shows a textual progress bar.}

\item{include_raw}{Logical; if TRUE, each row of the returned tibble will
include a \code{raw_response} list-column with the parsed JSON body from
OpenAI.}

\item{...}{Additional OpenAI parameters (temperature, top_p, logprobs,
reasoning, and so on) passed on to \code{openai_compare_pair_live}.}
}
\value{
A tibble with one row per pair and the same columns as
\code{\link{openai_compare_pair_live}}, including a \code{thoughts}
column for reasoning summaries (when available).
}
\description{
This is a thin row-wise wrapper around
\code{\link{openai_compare_pair_live}}. It takes a tibble of pairs
(ID1 / text1 / ID2 / text2), submits each pair to
the OpenAI API, and binds the results into a single tibble.
}
\details{
The output has the same columns as \code{\link{openai_compare_pair_live}},
with one row per pair, making it easy to pass into
\code{\link{build_bt_data}} and \code{\link{fit_bt_model}}.
}
\examples{
\dontrun{
# Requires API key set and internet access

data("example_writing_samples", package = "pairwiseLLM")

pairs <- example_writing_samples |>
  make_pairs() |>
  sample_pairs(n_pairs = 5, seed = 123) |>
  randomize_pair_order(seed = 456)

td <- trait_description("overall_quality")
tmpl <- set_prompt_template()

# Live comparisons for multiple pairs
res_live <- submit_openai_pairs_live(
  pairs             = pairs,
  model             = "gpt-4.1",
  trait_name        = td$name,
  trait_description = td$description,
  prompt_template   = tmpl,
  endpoint          = "chat.completions",
  temperature       = 0,
  verbose           = TRUE,
  status_every      = 2,
  progress          = TRUE,
  include_raw       = FALSE
)

res_live$better_id

# Using gpt-5.1 with reasoning on the responses endpoint
res_live_gpt5 <- submit_openai_pairs_live(
  pairs             = pairs,
  model             = "gpt-5.1",
  trait_name        = td$name,
  trait_description = td$description,
  prompt_template   = tmpl,
  endpoint          = "responses",
  reasoning         = "low",
  temperature       = NULL,
  top_p             = NULL,
  logprobs          = NULL,
  verbose           = TRUE,
  status_every      = 3,
  progress          = TRUE,
  include_raw       = TRUE
)

str(res_live_gpt5$raw_response[[1]], max.level = 2)
}

}
