% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataspace.R
\name{pa_download_dataspace}
\alias{pa_download_dataspace}
\title{Download satellite products from the Copernicus
  Data Space Ecosystem}
\usage{
pa_download_dataspace(x, dir.path = NULL, aoi = NULL, verbose = TRUE)
}
\arguments{
\item{x}{object of class \sQuote{dslist}}

\item{dir.path}{directory path to which the files will be
saved}

\item{aoi}{NULL or an sf object. If an area of interest
(aoi) is provided, the downloaded zip files will be
cropped to the aoi. This was designed to save storage
space}

\item{verbose}{whether to display information on the
progress of operations}
}
\value{
a list of objects
  that could not be downloaded
}
\description{
Download satellite products from the
  Copernicus Data Space Ecosystem to find satellite
  products
}
\details{
`pa_download_dataspace()` uses the object from
  `pa_browse_dataspace()` to download the data from
  Copernicus Data Space. The aoi argument is optional but
  was designed to save storage space.
}
\examples{
\dontrun{
extd.dir <- system.file("extdata", package = "pacu")
area.of.interest <- sf::st_read(file.path(extd.dir, 'cobs_a_aoi.shp'), quiet = TRUE)
available.images <- pa_browse_dataspace(aoi = area.of.interest,
                                        max.cloud.cover = 10,
                                        start.date = '2023-01-01',
                                        end.date = '2023-12-31')
dwonloaded.images <- pa_download_dataspace(x = available.images)

}

}
\author{
Caio dos Santos and Fernando Miguez
}
