test_that("spinner_outlier_score returns expected structure", {

  set.seed(1)
  X <- matrix(rnorm(100), ncol = 2)

  res <- spinner_outlier_score(
    X,
    n_spins = 50,
    robust = TRUE,
    cov_adjust = TRUE
  )

  expect_true(is.list(res))
  expect_true(is.numeric(res$score))
  expect_length(res$score, nrow(X))
  expect_equal(ncol(res$dim_contrib_norm), ncol(X))
})


test_that("spinner scores are non-negative", {
  X <- matrix(rnorm(100), ncol = 3)
  res <- spinner_outlier_score(X, n_spins = 50)
  expect_true(all(res$score >= 0))
})


test_that("robust and non-robust modes both run", {
  X <- matrix(rnorm(100), ncol = 2)

  res1 <- spinner_outlier_score(X, robust = TRUE,  n_spins = 50)
  res2 <- spinner_outlier_score(X, robust = FALSE, n_spins = 50)

  expect_length(res1$score, nrow(X))
  expect_length(res2$score, nrow(X))
})


