% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validator.R
\name{v_logical_scalar}
\alias{v_logical_scalar}
\title{Validator for Logical Scalar Values}
\usage{
v_logical_scalar()
}
\value{
A validator function that takes a value \code{x} and raises an error
if \code{x} is not a single logical value.
}
\description{
\code{v_logical_scalar()} returns a validator function that checks if a value
is a single logical value. This is useful as a validator function for
options managers created with \code{\link[=create_options_manager]{create_options_manager()}}.
}
\examples{
# Create a validator for logical scalars
validator <- v_logical_scalar()

# Valid input
validator(TRUE)

# Invalid inputs (would raise errors)
try(validator(c(TRUE, FALSE))) # vector, not scalar
try(validator(1)) # numeric, not logical
}
