% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_set_sheetview}
\alias{wb_set_sheetview}
\title{Modify the default view of a worksheet}
\usage{
wb_set_sheetview(
  wb,
  sheet = current_sheet(),
  color_id = NULL,
  default_grid_color = NULL,
  right_to_left = NULL,
  show_formulas = NULL,
  show_grid_lines = NULL,
  show_outline_symbols = NULL,
  show_row_col_headers = NULL,
  show_ruler = NULL,
  show_white_space = NULL,
  show_zeros = NULL,
  tab_selected = NULL,
  top_left_cell = NULL,
  view = NULL,
  window_protection = NULL,
  workbook_view_id = NULL,
  zoom_scale = NULL,
  zoom_scale_normal = NULL,
  zoom_scale_page_layout_view = NULL,
  zoom_scale_sheet_layout_view = NULL,
  ...
)
}
\arguments{
\item{wb}{A \link{wbWorkbook} object.}

\item{sheet}{The name or index of the worksheet. Defaults to the current sheet.}

\item{color_id, default_grid_color}{Integer; internal color index for grid
lines. Default is 64 (automatic).}

\item{right_to_left}{Logical; if \code{TRUE}, column ordering is right-to-left.}

\item{show_formulas}{Logical; if \code{TRUE}, cells display their formulas
instead of calculated values.}

\item{show_grid_lines}{Logical; if \code{TRUE} (default), the worksheet grid
lines are visible.}

\item{show_outline_symbols}{Logical; if \code{TRUE}, shows symbols for grouped
rows or columns.}

\item{show_row_col_headers}{Logical; if \code{TRUE}, shows the letters (columns)
and numbers (rows) at the edges of the sheet.}

\item{show_ruler}{Logical; if \code{TRUE}, a ruler is shown in "Page Layout" view.}

\item{show_white_space}{Logical; if \code{TRUE}, margins and page gaps are shown
in "Page Layout" view.}

\item{show_zeros}{Logical; if \code{FALSE}, cells containing a value of zero
appear blank.}

\item{tab_selected}{Integer; a zero-based index indicating if this sheet
tab is selected.}

\item{top_left_cell}{Character; the address of the cell that should be
positioned in the top-left corner of the view (e.g., "B10").}

\item{view}{Character; the view mode. One of \code{"normal"}, \code{"pageBreakPreview"},
or \code{"pageLayout"}.}

\item{window_protection}{Logical; if \code{TRUE}, the panes within the sheet
view are protected.}

\item{workbook_view_id}{Integer; links the sheet view to a specific
global workbook view.}

\item{zoom_scale, zoom_scale_normal, zoom_scale_page_layout_view, zoom_scale_sheet_layout_view}{Integer; the zoom percentage (between 10 and 400).}

\item{...}{Additional arguments.}
}
\value{
The \link{wbWorkbook} object, invisibly.

The \code{wbWorkbook} object, invisibly
}
\description{
The \code{wb_set_sheetview()} function controls the visual presentation of a
worksheet. It allows you to toggle UI elements like grid lines, row/column
headers, and formula visibility, as well as setting the zoom level and
view mode (e.g., Normal vs. Page Layout).
}
\details{
Sheet views are saved properties that tell the spreadsheet application
how to render the sheet upon opening. These settings are specific to the
worksheet and do not affect the actual data or styles of the cells.

Common Use Cases:
\itemize{
\item Zooming: Use \code{zoom_scale} to make large datasets more readable or
to provide a high-level dashboard view.
\item Clean Layouts: For reports or dashboards, setting \code{show_grid_lines = FALSE}
and \code{show_row_col_headers = FALSE} creates a cleaner, application-like
interface.
\item Audit Mode: Setting \code{show_formulas = TRUE} is helpful for debugging
complex spreadsheets by displaying the formulas directly in the cells.
\item Right-to-Left: Essential for spreadsheets in languages like Arabic
or Hebrew.
}
}
\examples{
wb <- wb_workbook()$add_worksheet()

wb$set_sheetview(
  zoom_scale = 75,
  right_to_left = FALSE,
  show_formulas = TRUE,
  show_grid_lines = TRUE,
  show_outline_symbols = FALSE,
  show_row_col_headers = TRUE,
  show_ruler = TRUE,
  show_white_space = FALSE,
  tab_selected = 1,
  top_left_cell = "B1",
  view = "normal",
  window_protection = TRUE
)
}
