% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logger.R
\name{logMessage}
\alias{logMessage}
\title{Log a message to a logFile}
\usage{
logMessage(
  message = "Start logging file",
  logFile = getOption("omopgenerics.logFile")
)
}
\arguments{
\item{message}{Message to log.}

\item{logFile}{File path to write logging messages. Create a logFile with
\code{createLogFile()}.}
}
\value{
Invisible TRUE if the logging message is written to a log file.
}
\description{
The message is written to the logFile and displayed in the console, if
\code{logFile} does not exist the message is only displayed in the console.
}
\examples{
library(dplyr)

logFile <- tempfile(pattern = "log_{date}_{time}", fileext = ".txt")
createLogFile(logFile = logFile)

logMessage("Starting analysis")
1 + 1
logMessage("Analysis finished")

res <- summariseLogFile()

glimpse(res)

tidy(res)

}
