plot.np.lm.test <-
  function(x, which = 1, alpha = 0.05, col = "grey", col.rr = "red",
           col.stat = "black", lty.stat = 2, lwd.stat = 2,
           xlab = "Test Statistic", main = "Permutation Distribution", 
           breaks = "scott", border = NA, box = TRUE, SQRT = TRUE, ...){
    
    if(!is.null(x$perm.dist)){
      
      # check "alpha"
      alpha <- as.numeric(alpha[1])
      if(alpha <= 0 | alpha >= 1) stop("Input 'alpha' must be between 0 and 1")
      
      # check SQRT
      if(SQRT){
        x$perm.dist <- sqrt(x$perm.dist)
        x$statistic <- sqrt(x$statistic)
      }
      
      # check term
      which <- as.integer(which)
      if(which < 1L | which > nrow(x$signif.table)) stop("Input 'which' must satisfy: 1 <= which <= nrow(x$signif.table)")
      
      # get breaks and midpoints
      h <- suppressWarnings(hist(x$perm.dist[,which], breaks = breaks, plot = FALSE, ...))
      
      # define colors
      cval <- quantile(x$perm.dist[,which], probs = 1 - alpha)
      hcol <- ifelse(h$mids >= cval, col.rr, col)
      
      # plot perm.test
      hist(x$perm.dist[,which], breaks = breaks, col = hcol, 
           border = border, main = main, xlab = xlab, ...)
      if(box) box()
      
      # plot statistic
      abline(v = x$statistic[which], lty = lty.stat, lwd = lwd.stat, col = col.stat)
      
    } else {
      
      warning("Plot unavailable because perm.dist is NULL\nSet perm.dist = TRUE when calling np.lm.test")
      
    }
    
  } # end plot.np.lm.test