% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/categories.R, R/data.R
\docType{data}
\name{categories}
\alias{categories}
\title{Categories: Uniform Distribution of Bikinibottom Species}
\format{
A data frame with 250 rows and 1 variable:
\describe{
\item{animal}{Character. Species/animal names. 11 species inspired by Bikini Bottom.}
}

A data frame with 1 column:
\describe{
\item{animal}{Factor with animal categories as letters}
}
}
\source{
Generated for examples
}
\usage{
categories

categories
}
\description{
A dataset of dummy nominal data inspired by characters/species
from the Bikini Bottom universe (SpongeBob SquarePants).
This dataset simulates a roughly uniform distribution across 11 species,
with a total of 250 observations. It was intentionally designed to be uniform-like
for testing nominal distribution visualization functions.

A simple dataset of categorical values used for examples.
}
\examples{
categories
# Ranked bar plot of species frequencies
ranked_barplot(categories, "animal")

# Centered bar plot (most frequent in the center)
centered_barplot(categories, "animal")

# Centered dot plot with theoretical shape overlays
shape_comp_plot(categories, "animal")
}
\keyword{datasets}
