################################################################################
#
#'
#' Example dataset for age heaping function
#'
#' Anthropometric data from a Rapid Assessment Method for Older People (RAM-OP)
#' survey in the Dadaab refugee camp in Garissa, Kenya. This is a survey of
#' people aged sixty years and older.
#'
#' @format A data frame with 593 observations and 10 variables
#'
#' | **Variable** | **Description** |
#' | :--- | :--- |
#' | *psu* | Primary sampling unit |
#' | *camp* | Camp name code |
#' | *block* | Block code |
#' | *age* | Age (years) |
#' | *sex* | Sex |
#' | *weight* | Weight (kg) |
#' | *height* | Height (cm) |
#' | *demispan* | Demispan (cm) |
#' | *muac* | Mid-upper arm circumference (cm) |
#' | *oedema* | Oedema |
#'
#' @source Data courtesy of [HelpAge International](https://www.helpage.org)
#'
#
################################################################################
"ah.ex01"


################################################################################
#
#'
#' Example dataset for age and sex distributions function
#'
#' Data taken from household rosters collected as part of a household survey in
#' Tanzania.
#'
#' @format A data frame of 8736 observations and 2 variables
#'
#' | **Variable** | **Description** |
#' | :--- | :--- |
#' | *age* | Age (years) |
#' | *sex* | Sex (1 = Male / 2 = Female) |
#'
#
################################################################################
"as.ex01"


################################################################################
#
#'
#' Example dataset for age and sex distributions function
#'
#' Census data of Tanzania taken from the Wolfram|Alpha knowledge engine.
#'
#' @format A data frame with 20 observations and 4 variables
#'
#' | **Variable** | **Description** |
#' | :--- | :--- |
#' | *age* | Age group |
#' | *Males* | Total male population |
#' | *Females* | Total female population |
#' | *All* | Total population |
#'
#' @source Wolfram|Alpha
#'
#
################################################################################
"as.ex02"


################################################################################
#
#'
#' Example dataset for distributions of variables and indices
#'
#' Anthropometric data from a SMART survey in Kabul, Afghanistan.
#'
#' @format A data frame with 873 observations and 11 variables
#'
#' | **Variable** | **Description** |
#' | :--- | :--- |
#' | *psu* | Primary sampling unit |
#' | *age* | Age of child (months) |
#' | *sex* | Gender of child |
#' | *weight* | Weight of child (kgs) |
#' | *height* | Height of child (cm) |
#' | *muac* | Mid-upper arm circumference (mm) |
#' | *oedema* | Presence or absence of oedema |
#' | *haz* | Height-for-age z-score |
#' | *waz* | Weight-for-age z-score |
#' | *whz* | Weight-for-height z-score |
#' | *flag* | Data quality flag |
#'
#
################################################################################
"dist.ex01"


################################################################################
#
#'
#' Example dataset for digit preference function
#'
#' Anthropometric data from a single state from a Demographic and Health Survey
#' (DHS) of a West African country.
#'
#' @format A data frame with 796 observations and 6 variables
#'
#' | **Variable** | **Description** |
#' | :--- | :--- |
#' | *psu* | Primary sampling unit |
#' | *age* | Age (months) |
#' | *sex* | Gender |
#' | *wt* | Weight (kg) |
#' | *ht* | height (cm) |
#' | *oedema* | Presence or absence of oedema |
#'
#
################################################################################
"dp.ex01"


################################################################################
#
#'
#' Example dataset for digit preference function
#'
#' Anthropometric data from a SMART survey in Kabul, Afghanistan in a
#' comma-separated-value (CSV) file format. This is a survey of children aged
#' 6-59 months old.
#'
#' @format A data frame with 873 observations and 7 variables
#'
#' | **Variable** | **Description** |
#' | :--- | :--- |
#' | *psu* | Primary sampling unit |
#' | *age* | Age of child (months) |
#' | *sex* | Gender of child |
#' | *weight* | Weight of child (kgs) |
#' | *height* | Height of child (cm) |
#' | *muac* | Mid-upper arm circumference (mm) |
#' | *oedema* | Presence or absence of oedema |
#'
#
################################################################################
"dp.ex02"


################################################################################
#
#'
#' Example dataset for digit preference
#'
#' Anthropometric data for a sample of children living in a refugee camp in a
#' West African country.
#'
#' @format A data frame with 374 observations and 6 variables
#'
#' | **Variable** | **Description** |
#' | :--- | :--- |
#' | *age* | Age (months) |
#' | *sex* | Gender (1 = Male / 2 = Female) |
#' | *weight* | Weight (kg) |
#' | *height* | Height (cm) |
#' | *muac* | Mid-upper arm circumference (mm) |
#' | *oedema* | Presence or absence of oedema |
#'
#
################################################################################
"dp.ex03"


################################################################################
#
#'
#' Example dataset for identifying outliers using flags
#'
#' Anthropometric data from a SMART survey in Sudan.
#'
#' @format A data frame with 786 observations and 11 variables
#'
#' | **Variable** | **Description** |
#' | :--- | :--- |
#' | *psu* | Primary sampling unit |
#' | *child* | Child ID |
#' | *age* | Age (months) |
#' | *sex* | Gender (1 = Male / 2 = Female) |
#' | *weight* | Weight (kg) |
#' | *height* | Height (cm) |
#' | *muac* | Mid-upper arm circumference (mm) |
#' | *oedema* | Presence or absence of oedema |
#' | *haz* | Height-for-age z-score |
#' | *waz* | Weight-for-age z-score |
#' | *whz* | Weight-for-height z-score |
#'
#
################################################################################
"flag.ex01"


################################################################################
#
#'
#' Example dataset for identifying outliers using flags
#'
#' Anthropometric data from a survey of children 11 years or older attending
#' school in Ethiopia.
#'
#' @format A data.frame with 973 observations and 7 variables.
#'
#' | **Variable** | **Description** |
#' | :--- | :--- |
#' | *school* | School ID |
#' | *sex* | Gender (1 = Male / 2 = Female) |
#' | *ageMonths* | Age (months) |
#' | *weight* | Weight (kg) |
#' | *height* | Height (cm) |
#' | *haz* | Height-for-age z-score |
#' | *baz* | Body mass index (BMI)-for-age z-score |
#'
#
################################################################################
"flag.ex02"


################################################################################
#
#'
#' Example dataset for identifying outliers using flags
#'
#' Anthropometric data from a national survey in Nigeria.
#'
#' @format A data frame with 18330 observations and 10 variables
#'
#' | **Variable** | **Description** |
#' | :--- | :--- |
#' | *psu* | Primary sampling unit |
#' | *region* | Region code |
#' | *state* | State |
#' | *age* | Age (months) |
#' | *sex* | Gender (1 = Male / 2 = Female) |
#' | *weight* | Weight (kg) |
#' | *height* | Height (cm) |
#' | *haz* | Height-for-age z-score |
#' | *waz* | Weight-for-age z-score |
#' | *whz* | Weight-for-height z-score |
#'
#
################################################################################
"flag.ex03"


################################################################################
#
#'
#' Example dataset for checking ranges and legal values
#'
#' Anthropometric data from a SMART survey in Angola.
#'
#' @format A data frame with 906 observations and 6 variables
#'
#' | **Variable** | **Description** |
#' | :--- | :--- |
#' | *age* | Age (months) |
#' | *sex* | Gender (1 = Male / 2 = Female) |
#' | *weight* | Weight (kg) |
#' | *height* | Height (cm) |
#' | *muac* | Mid-upper arm circumference (mm) |
#' | *oedema* | Presence or absence of oedema |
#'
#
################################################################################
"rl.ex01"


################################################################################
#
#'
#' Example dataset for using scatterplots to identify outliers
#'
#' Anthropometric data from a SMART survey in the Democratic Republic of Congo.
#'
#' @format A data frame with 895 observations and 6 variables
#'
#' | **Variable** | **Description** |
#' | :--- | :--- |
#' | *age* | Age (months) |
#' | *sex* | Gender (1 = Male / 2 = Female) |
#' | *weight* | Weight (kg) |
#' | *height* | Height (cm) |
#' | *muac* | Mid-upper arm circumference (mm) |
#' | *oedema* | Presence or absence of oedema |
#'
#
################################################################################
"sp.ex01"


################################################################################
#
#'
#' Example dataset for using scatterplots to identify outliers
#'
#' Anthropometric data from a survey of school-age (i.e., between 5 and 15 years)
#' children from Pakistan
#'
#' @format A data frame with 849 observations and 9 variables
#'
#' | **Variable** | **Description** |
#' | :--- | :--- |
#' | *region* | Region code |
#' | *school* | School code |
#' | *ageMonths* | Age (months) |
#' | *sex* | Sex (1 = Male / 2 = Female) |
#' | *weight* | Weight (kg) |
#' | *height* | Height (cm) |
#' | *haz* | Height-for-age z-score |
#' | *waz* | Weight-for-age z-score |
#' | *baz* | Body mass index (BMI)-for-age z-score |
#'
#
################################################################################
"sp.ex02"
