% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NilsEstimate-summary.R
\name{summary.NilsEstimate}
\alias{summary.NilsEstimate}
\alias{print.summary.NilsEstimate}
\title{Summarize a NILS estimate}
\usage{
\method{summary}{NilsEstimate}(object, ...)

\method{print}{summary.NilsEstimate}(x, ...)
}
\arguments{
\item{object}{A \link{NilsEstimate} object.}

\item{...}{Additional arguments (currently unused).}

\item{x}{A \link{summary.NilsEstimate}.}
}
\value{
The returned list has the following components:
\describe{
\item{estimate}{Estimated total of the target variable.}
\item{variance}{Estimated variance of the total estimator.}
\item{rel_se}{Estimated relative standard error of the total estimator.}
\item{nonnil_tracts}{Number of non-nil tracts. Not shown if filtering has been applied.}
}
}
\description{
Produces summary statistics for a \link{NilsEstimate} object.
}
\examples{
obj = NilsEstimate(plots, tracts, psus, category_psu_map);
summary(obj);

}
