% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_name_cleaning.R
\name{clean_player_names}
\alias{clean_player_names}
\title{Create Player Merge Names}
\usage{
clean_player_names(
  player_name,
  lowercase = FALSE,
  convert_lastfirst = TRUE,
  use_name_database = TRUE,
  convert_to_ascii = rlang::is_installed("stringi")
)
}
\arguments{
\item{player_name}{a character vector of player names}

\item{lowercase}{defaults to FALSE - if TRUE, converts to lowercase}

\item{convert_lastfirst}{defaults to TRUE - converts names from "Last, First" to "First Last"}

\item{use_name_database}{uses internal name database to do common substitutions (Mitchell Trubisky to Mitch Trubisky etc)}

\item{convert_to_ascii}{If \code{TRUE}, will transliterate to latin-ascii via the
stringi package. Defaults to \code{TRUE} if the stringi package is installed.}
}
\value{
a character vector of cleaned names
}
\description{
Applies some name-cleaning heuristics to facilitate joins. These heuristics may include:
\itemize{
\item removing periods and apostrophes
\item removing common suffixes, such as Jr, Sr, II, III, IV
\item converting to lowercase
\item using \code{ffscrapr::dp_name_mapping} to do common name substitutions, such as Mitch Trubisky to Mitchell Trubisky
}
}
\details{
Equivalent to the operation done by \code{ffscrapr::dp_clean_names()} and uses the same player name database.
}
\examples{
\dontshow{.for_cran()}
clean_player_names(c("A.J. Green", "Odell Beckham Jr.  ", "Le'Veon Bell Sr."))

clean_player_names(c("Trubisky,      Mitch", "Atwell, Chatarius", "Elliott, Zeke", "Elijah Moore"),
                  convert_lastfirst = TRUE)

}
