% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find.R
\name{get_manufacturer_info}
\alias{get_manufacturer_info}
\title{Enhanced Get Manufacturer Info with Smart Matching}
\usage{
get_manufacturer_info(
  manufacturer,
  series = "all",
  type = "summary",
  interactive = TRUE
)
}
\arguments{
\item{manufacturer}{Character string of manufacturer name to search for}

\item{series}{Either character string ("cup", "xfinity", "truck", "all") or data frame}

\item{type}{Character string specifying return type ("summary", "season", "all")}

\item{interactive}{Logical. Is the session interactive?}
}
\value{
Tibble with manufacturer statistics or NULL if no exact match
}
\description{
Enhanced Get Manufacturer Info with Smart Matching
}
\examples{
\dontrun{
# Get Toyota career summary
get_manufacturer_info("Toyota")

# Handle misspelling - will prompt for selection
get_manufacturer_info("toyoda")
# Found 1 manufacturers matching 'toyoda':
#  1 - Toyota
# Select manufacturer number: 1
# Manufacturer: Toyota
# Returns summary table

# Get season-by-season data for Cup series only
get_manufacturer_info("Toyota", series = "cup", type = "season")
}
}
