// This file is part of UFAL C++ Utils <http://github.com/ufal/cpp_utils/>.
//
// Copyright 2015 Institute of Formal and Applied Linguistics, Faculty of
// Mathematics and Physics, Charles University in Prague, Czech Republic.
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.

#include "url_detector.h"

namespace ufal {
namespace nametag {
namespace utils {


static const char _url_detector_actions[] = {
	0, 1, 0, 1, 3, 2, 0, 1, 
	2, 2, 0, 2, 3, 0
};

static const char _url_detector_cond_offsets[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2
};

static const char _url_detector_cond_lengths[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0
};

static const short _url_detector_cond_keys[] = {
	41u, 41u, 41u, 41u, 0
};

static const char _url_detector_cond_spaces[] = {
	0, 0, 0
};

static const short _url_detector_key_offsets[] = {
	0, 0, 15, 29, 41, 54, 63, 71, 
	78, 86, 92, 100, 153, 161, 167, 169, 
	177, 184, 192, 196, 200, 204, 209, 214, 
	223, 227, 231, 240, 242, 246, 248, 251, 
	283, 285, 287, 289, 291, 297, 312, 327, 
	346, 358, 374, 386, 402, 418, 439, 449, 
	461, 477, 491, 506, 516, 529, 538, 550, 
	552, 556, 577, 586, 596, 602, 608, 609, 
	653, 657, 661, 669, 680, 690, 697, 703, 
	709, 713, 717, 719, 723, 727, 731, 737, 
	745, 754, 760, 762, 766, 768, 774, 778, 
	782, 786, 790, 795, 802, 808, 810, 814, 
	820, 824, 830, 841, 846, 860, 880, 885, 
	889, 891, 907, 912, 914, 916, 918, 920, 
	922, 926, 930, 935, 941, 945, 955, 965, 
	966, 979, 987, 995, 999, 1003, 1009, 1011, 
	1013, 1017, 1021, 1026, 1028, 1031, 1033, 1055, 
	1057, 1059, 1063, 1068, 1072, 1078, 1080, 1084, 
	1092, 1096, 1100, 1105, 1107, 1115, 1123, 1135, 
	1141, 1147, 1151, 1155, 1159, 1178, 1180, 1191, 
	1197, 1199, 1201, 1205, 1209, 1213, 1217, 1219, 
	1223, 1227, 1229, 1237, 1253, 1295, 1304, 1308, 
	1310, 1312, 1314, 1316, 1317, 1321, 1325, 1329, 
	1335, 1339, 1343, 1345, 1349, 1358, 1364, 1368, 
	1374, 1378, 1382, 1395, 1399, 1401, 1407, 1413, 
	1417, 1419, 1421, 1425, 1427, 1452, 1457, 1461, 
	1465, 1468, 1477, 1481, 1492, 1496, 1512, 1526, 
	1531, 1535, 1538, 1542, 1548, 1551, 1558, 1560, 
	1562, 1565, 1568, 1570, 1581, 1585, 1589, 1599, 
	1601, 1605, 1607, 1611, 1613, 1617, 1623, 1643, 
	1649, 1655, 1657, 1659, 1663, 1677, 1681, 1693, 
	1700, 1704, 1711, 1717, 1723, 1729, 1735, 1739, 
	1742, 1747, 1753, 1757, 1771, 1797, 1807, 1808, 
	1811, 1813, 1817, 1819, 1822, 1824, 1827, 1829, 
	1830, 1833, 1835, 1837, 1846, 1854, 1863, 1871, 
	1880, 1888, 1896, 1907, 1917, 1925, 1933, 1944, 
	1954, 1962, 1970, 1981, 1991, 2000, 2008, 2015, 
	2023, 2029, 2037, 2046, 2054, 2063, 2071, 2080, 
	2088, 2096, 2107, 2117, 2125, 2133, 2144, 2154, 
	2162, 2170, 2181, 2191, 2207, 2222, 2238, 2252, 
	2268, 2280, 2297, 2313, 2330, 2346, 2363, 2379, 
	2395, 2414, 2432, 2448, 2464, 2483, 2501, 2517, 
	2533, 2552, 2570, 2586, 2602, 2618, 2629, 2630, 
	2645, 2659, 2675, 2690, 2706, 2720, 2736, 2753, 
	2769, 2786, 2802, 2819, 2835, 2851, 2870, 2888, 
	2904, 2920, 2939, 2957, 2973, 2989, 3008, 3026, 
	3036, 3089, 3092, 3102, 3112, 3122, 3135, 3147, 
	3157, 3167, 3177, 3187, 3200, 3212, 3229, 3243, 
	3260, 3277, 3294, 3314, 3333, 3350, 3367, 3384, 
	3401, 3421
};

static const short _url_detector_trans_keys[] = {
	33u, 48u, 49u, 50u, 95u, 36u, 37u, 39u, 
	46u, 51u, 57u, 65u, 90u, 97u, 122u, 33u, 
	58u, 64u, 95u, 36u, 37u, 39u, 46u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 95u, 36u, 
	37u, 39u, 46u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 64u, 95u, 36u, 37u, 39u, 46u, 
	48u, 57u, 65u, 90u, 97u, 122u, 48u, 49u, 
	50u, 51u, 57u, 65u, 90u, 97u, 122u, 45u, 
	46u, 48u, 57u, 65u, 90u, 97u, 122u, 45u, 
	48u, 57u, 65u, 90u, 97u, 122u, 45u, 46u, 
	48u, 57u, 65u, 90u, 97u, 122u, 48u, 57u, 
	65u, 90u, 97u, 122u, 45u, 46u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 39u, 40u, 44u, 
	46u, 61u, 63u, 95u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 297u, 553u, 36u, 38u, 42u, 57u, 58u, 
	59u, 64u, 90u, 97u, 122u, 196u, 218u, 229u, 
	236u, 170u, 181u, 178u, 179u, 185u, 186u, 188u, 
	190u, 128u, 150u, 152u, 182u, 184u, 191u, 128u, 
	191u, 172u, 174u, 128u, 129u, 134u, 145u, 160u, 
	164u, 191u, 128u, 180u, 182u, 183u, 186u, 189u, 
	134u, 140u, 136u, 138u, 142u, 161u, 163u, 191u, 
	128u, 181u, 183u, 191u, 128u, 129u, 131u, 191u, 
	128u, 175u, 177u, 191u, 153u, 128u, 150u, 161u, 
	191u, 191u, 128u, 135u, 145u, 189u, 135u, 129u, 
	130u, 132u, 133u, 144u, 170u, 176u, 178u, 144u, 
	154u, 160u, 191u, 128u, 169u, 174u, 191u, 191u, 
	128u, 147u, 149u, 156u, 159u, 168u, 170u, 188u, 
	144u, 191u, 128u, 138u, 141u, 191u, 128u, 177u, 
	186u, 128u, 181u, 160u, 161u, 162u, 163u, 164u, 
	165u, 166u, 167u, 168u, 169u, 170u, 171u, 172u, 
	173u, 174u, 175u, 176u, 177u, 178u, 179u, 180u, 
	181u, 182u, 183u, 184u, 185u, 186u, 187u, 188u, 
	189u, 190u, 191u, 128u, 173u, 128u, 155u, 160u, 
	180u, 163u, 191u, 128u, 163u, 166u, 175u, 177u, 
	191u, 178u, 128u, 131u, 133u, 140u, 143u, 144u, 
	147u, 168u, 170u, 176u, 182u, 185u, 188u, 191u, 
	151u, 128u, 132u, 135u, 136u, 139u, 142u, 156u, 
	157u, 159u, 163u, 166u, 177u, 180u, 185u, 188u, 
	129u, 131u, 133u, 138u, 143u, 144u, 147u, 168u, 
	170u, 176u, 178u, 179u, 181u, 182u, 184u, 185u, 
	190u, 191u, 145u, 158u, 128u, 130u, 135u, 136u, 
	139u, 141u, 153u, 156u, 166u, 181u, 129u, 131u, 
	133u, 141u, 143u, 145u, 147u, 168u, 170u, 176u, 
	178u, 179u, 181u, 185u, 188u, 191u, 144u, 185u, 
	128u, 133u, 135u, 137u, 139u, 141u, 160u, 163u, 
	166u, 175u, 129u, 131u, 133u, 140u, 143u, 144u, 
	147u, 168u, 170u, 176u, 178u, 179u, 181u, 185u, 
	188u, 191u, 128u, 132u, 135u, 136u, 139u, 141u, 
	150u, 151u, 156u, 157u, 159u, 163u, 166u, 175u, 
	177u, 183u, 156u, 130u, 131u, 133u, 138u, 142u, 
	144u, 146u, 149u, 153u, 154u, 158u, 159u, 163u, 
	164u, 168u, 170u, 174u, 185u, 190u, 191u, 144u, 
	151u, 128u, 130u, 134u, 136u, 138u, 141u, 166u, 
	178u, 128u, 131u, 133u, 140u, 142u, 144u, 146u, 
	168u, 170u, 185u, 189u, 191u, 128u, 132u, 134u, 
	136u, 138u, 141u, 149u, 150u, 152u, 154u, 160u, 
	163u, 166u, 175u, 184u, 190u, 129u, 131u, 133u, 
	140u, 142u, 144u, 146u, 168u, 170u, 179u, 181u, 
	185u, 188u, 191u, 158u, 128u, 132u, 134u, 136u, 
	138u, 141u, 149u, 150u, 160u, 163u, 166u, 175u, 
	177u, 178u, 129u, 131u, 133u, 140u, 142u, 144u, 
	146u, 186u, 189u, 191u, 151u, 128u, 132u, 134u, 
	136u, 138u, 142u, 159u, 163u, 166u, 181u, 186u, 
	191u, 189u, 130u, 131u, 133u, 150u, 154u, 177u, 
	179u, 187u, 138u, 150u, 128u, 134u, 143u, 148u, 
	152u, 159u, 166u, 175u, 178u, 179u, 129u, 186u, 
	128u, 142u, 144u, 153u, 132u, 138u, 141u, 165u, 
	167u, 129u, 130u, 135u, 136u, 148u, 151u, 153u, 
	159u, 161u, 163u, 170u, 171u, 173u, 185u, 187u, 
	189u, 134u, 128u, 132u, 136u, 141u, 144u, 153u, 
	156u, 159u, 128u, 181u, 183u, 185u, 152u, 153u, 
	160u, 179u, 190u, 191u, 128u, 135u, 137u, 172u, 
	177u, 191u, 128u, 132u, 134u, 151u, 153u, 188u, 
	134u, 129u, 130u, 131u, 137u, 138u, 139u, 140u, 
	141u, 142u, 143u, 144u, 153u, 154u, 155u, 156u, 
	157u, 159u, 160u, 161u, 162u, 163u, 164u, 165u, 
	166u, 167u, 168u, 169u, 170u, 173u, 175u, 176u, 
	177u, 179u, 183u, 188u, 189u, 190u, 191u, 128u, 
	158u, 172u, 174u, 180u, 187u, 128u, 137u, 144u, 
	191u, 128u, 157u, 160u, 191u, 135u, 141u, 128u, 
	133u, 144u, 186u, 188u, 191u, 152u, 128u, 136u, 
	138u, 141u, 144u, 150u, 154u, 157u, 160u, 191u, 
	128u, 136u, 138u, 141u, 144u, 176u, 178u, 181u, 
	184u, 190u, 128u, 130u, 133u, 136u, 150u, 152u, 
	191u, 128u, 144u, 146u, 149u, 152u, 191u, 128u, 
	154u, 157u, 159u, 169u, 188u, 128u, 143u, 160u, 
	191u, 128u, 181u, 184u, 189u, 129u, 191u, 128u, 
	172u, 175u, 191u, 129u, 154u, 160u, 191u, 128u, 
	170u, 174u, 184u, 128u, 140u, 142u, 148u, 160u, 
	180u, 128u, 147u, 160u, 172u, 174u, 176u, 178u, 
	179u, 151u, 128u, 147u, 156u, 157u, 160u, 169u, 
	176u, 185u, 139u, 141u, 144u, 153u, 160u, 191u, 
	128u, 183u, 128u, 170u, 176u, 191u, 128u, 181u, 
	128u, 158u, 160u, 171u, 176u, 187u, 134u, 173u, 
	176u, 180u, 128u, 171u, 176u, 191u, 128u, 137u, 
	144u, 154u, 128u, 155u, 160u, 191u, 191u, 128u, 
	158u, 160u, 188u, 167u, 128u, 137u, 144u, 153u, 
	176u, 190u, 128u, 139u, 144u, 153u, 171u, 179u, 
	128u, 179u, 128u, 137u, 141u, 189u, 144u, 146u, 
	148u, 182u, 184u, 185u, 128u, 181u, 188u, 191u, 
	128u, 149u, 152u, 157u, 160u, 191u, 153u, 155u, 
	157u, 128u, 133u, 136u, 141u, 144u, 151u, 159u, 
	189u, 190u, 128u, 180u, 182u, 188u, 130u, 132u, 
	134u, 140u, 144u, 147u, 150u, 155u, 160u, 172u, 
	178u, 180u, 182u, 188u, 129u, 130u, 131u, 132u, 
	133u, 134u, 145u, 146u, 147u, 157u, 158u, 176u, 
	177u, 178u, 179u, 180u, 181u, 182u, 183u, 184u, 
	191u, 176u, 177u, 180u, 185u, 128u, 137u, 144u, 
	156u, 144u, 176u, 130u, 135u, 149u, 164u, 166u, 
	168u, 138u, 147u, 153u, 157u, 170u, 173u, 175u, 
	185u, 188u, 191u, 142u, 133u, 137u, 144u, 191u, 
	128u, 137u, 160u, 191u, 170u, 191u, 182u, 191u, 
	128u, 147u, 128u, 174u, 176u, 191u, 128u, 158u, 
	160u, 191u, 189u, 128u, 164u, 171u, 179u, 167u, 
	173u, 128u, 165u, 176u, 191u, 175u, 191u, 128u, 
	167u, 128u, 150u, 160u, 166u, 168u, 174u, 176u, 
	182u, 184u, 190u, 128u, 134u, 136u, 142u, 144u, 
	150u, 152u, 158u, 160u, 191u, 175u, 128u, 129u, 
	130u, 131u, 132u, 133u, 134u, 135u, 136u, 137u, 
	138u, 144u, 191u, 133u, 135u, 161u, 175u, 177u, 
	181u, 184u, 188u, 128u, 150u, 153u, 154u, 157u, 
	159u, 161u, 191u, 128u, 186u, 188u, 191u, 133u, 
	173u, 177u, 191u, 128u, 142u, 146u, 149u, 160u, 
	186u, 176u, 191u, 160u, 169u, 136u, 143u, 145u, 
	159u, 128u, 137u, 177u, 191u, 182u, 128u, 181u, 
	184u, 191u, 128u, 191u, 191u, 128u, 190u, 128u, 
	149u, 146u, 147u, 152u, 153u, 155u, 156u, 158u, 
	159u, 160u, 161u, 163u, 164u, 165u, 167u, 168u, 
	169u, 171u, 172u, 173u, 175u, 128u, 191u, 128u, 
	140u, 144u, 189u, 128u, 140u, 144u, 171u, 191u, 
	128u, 178u, 180u, 189u, 151u, 159u, 162u, 191u, 
	128u, 136u, 139u, 173u, 176u, 183u, 183u, 191u, 
	128u, 167u, 176u, 181u, 187u, 189u, 128u, 132u, 
	144u, 153u, 160u, 183u, 128u, 173u, 176u, 191u, 
	128u, 147u, 160u, 188u, 128u, 143u, 153u, 160u, 
	190u, 128u, 182u, 128u, 141u, 144u, 153u, 160u, 
	182u, 186u, 191u, 128u, 130u, 155u, 157u, 160u, 
	175u, 178u, 182u, 129u, 134u, 137u, 142u, 145u, 
	150u, 160u, 166u, 168u, 174u, 176u, 191u, 128u, 
	154u, 156u, 165u, 176u, 191u, 128u, 170u, 172u, 
	173u, 176u, 185u, 158u, 159u, 128u, 157u, 128u, 
	163u, 176u, 191u, 128u, 134u, 139u, 187u, 169u, 
	171u, 172u, 173u, 174u, 175u, 180u, 181u, 182u, 
	183u, 184u, 185u, 187u, 188u, 189u, 190u, 191u, 
	164u, 186u, 128u, 153u, 190u, 128u, 134u, 147u, 
	151u, 157u, 168u, 170u, 182u, 184u, 188u, 128u, 
	129u, 131u, 132u, 134u, 191u, 147u, 191u, 128u, 
	189u, 128u, 143u, 146u, 191u, 128u, 135u, 176u, 
	187u, 128u, 143u, 160u, 175u, 176u, 180u, 182u, 
	191u, 128u, 188u, 144u, 153u, 161u, 186u, 129u, 
	154u, 166u, 191u, 128u, 190u, 130u, 135u, 138u, 
	143u, 146u, 151u, 154u, 156u, 144u, 145u, 146u, 
	147u, 148u, 150u, 155u, 157u, 158u, 159u, 170u, 
	171u, 172u, 175u, 160u, 169u, 128u, 129u, 130u, 
	131u, 132u, 133u, 134u, 135u, 138u, 139u, 140u, 
	141u, 142u, 143u, 146u, 148u, 149u, 156u, 157u, 
	160u, 161u, 162u, 163u, 164u, 166u, 167u, 168u, 
	169u, 170u, 171u, 172u, 173u, 174u, 176u, 177u, 
	178u, 179u, 185u, 144u, 145u, 152u, 155u, 191u, 
	128u, 139u, 141u, 166u, 168u, 186u, 188u, 189u, 
	128u, 141u, 144u, 157u, 128u, 186u, 135u, 179u, 
	128u, 184u, 138u, 139u, 189u, 128u, 156u, 160u, 
	191u, 128u, 144u, 160u, 187u, 128u, 138u, 144u, 
	186u, 128u, 131u, 136u, 143u, 145u, 149u, 128u, 
	157u, 160u, 169u, 128u, 167u, 176u, 191u, 128u, 
	163u, 128u, 149u, 160u, 167u, 136u, 188u, 191u, 
	128u, 133u, 138u, 181u, 183u, 184u, 128u, 149u, 
	152u, 182u, 185u, 191u, 128u, 158u, 167u, 175u, 
	160u, 178u, 180u, 181u, 187u, 191u, 128u, 155u, 
	160u, 185u, 128u, 183u, 188u, 191u, 191u, 128u, 
	131u, 133u, 134u, 140u, 147u, 149u, 151u, 153u, 
	179u, 184u, 186u, 128u, 135u, 160u, 190u, 128u, 
	159u, 128u, 135u, 137u, 166u, 171u, 175u, 128u, 
	149u, 152u, 178u, 184u, 191u, 128u, 145u, 169u, 
	175u, 128u, 136u, 128u, 178u, 128u, 178u, 186u, 
	191u, 160u, 190u, 129u, 130u, 131u, 132u, 133u, 
	135u, 136u, 138u, 139u, 140u, 141u, 146u, 147u, 
	150u, 151u, 152u, 153u, 154u, 155u, 156u, 162u, 
	163u, 171u, 128u, 134u, 191u, 128u, 134u, 146u, 
	175u, 144u, 168u, 176u, 185u, 128u, 180u, 182u, 
	191u, 182u, 144u, 179u, 156u, 128u, 132u, 138u, 
	140u, 144u, 154u, 161u, 180u, 128u, 145u, 147u, 
	183u, 136u, 128u, 134u, 138u, 141u, 143u, 157u, 
	159u, 168u, 176u, 191u, 128u, 170u, 176u, 185u, 
	128u, 131u, 133u, 140u, 143u, 144u, 147u, 168u, 
	170u, 176u, 178u, 179u, 181u, 185u, 188u, 191u, 
	144u, 151u, 128u, 132u, 135u, 136u, 139u, 141u, 
	157u, 163u, 166u, 172u, 176u, 180u, 135u, 128u, 
	133u, 144u, 153u, 128u, 181u, 184u, 191u, 128u, 
	152u, 157u, 128u, 132u, 144u, 153u, 128u, 153u, 
	157u, 171u, 176u, 187u, 191u, 128u, 178u, 142u, 
	145u, 149u, 128u, 141u, 144u, 148u, 128u, 174u, 
	128u, 131u, 144u, 128u, 143u, 153u, 144u, 152u, 
	128u, 134u, 168u, 169u, 171u, 172u, 173u, 174u, 
	188u, 189u, 190u, 160u, 167u, 128u, 158u, 160u, 
	169u, 144u, 173u, 176u, 180u, 128u, 131u, 144u, 
	153u, 155u, 161u, 163u, 183u, 189u, 191u, 128u, 
	143u, 128u, 132u, 144u, 190u, 143u, 159u, 128u, 
	176u, 177u, 178u, 128u, 129u, 128u, 170u, 176u, 
	188u, 128u, 136u, 144u, 153u, 157u, 158u, 133u, 
	134u, 137u, 141u, 145u, 146u, 147u, 148u, 149u, 
	154u, 155u, 156u, 157u, 158u, 159u, 168u, 169u, 
	170u, 144u, 153u, 165u, 169u, 173u, 178u, 187u, 
	191u, 128u, 130u, 133u, 139u, 170u, 173u, 130u, 
	132u, 160u, 177u, 128u, 148u, 150u, 191u, 162u, 
	187u, 128u, 156u, 158u, 159u, 165u, 166u, 169u, 
	172u, 174u, 185u, 189u, 191u, 128u, 131u, 133u, 
	191u, 128u, 133u, 135u, 138u, 141u, 148u, 150u, 
	156u, 158u, 185u, 187u, 190u, 134u, 128u, 132u, 
	138u, 144u, 146u, 191u, 128u, 165u, 168u, 191u, 
	128u, 130u, 154u, 156u, 186u, 188u, 191u, 128u, 
	148u, 150u, 180u, 182u, 191u, 128u, 142u, 144u, 
	174u, 176u, 191u, 128u, 136u, 138u, 168u, 170u, 
	191u, 128u, 130u, 132u, 139u, 142u, 191u, 128u, 
	182u, 187u, 191u, 181u, 128u, 172u, 132u, 155u, 
	159u, 161u, 175u, 163u, 184u, 185u, 186u, 160u, 
	162u, 128u, 132u, 135u, 150u, 164u, 167u, 185u, 
	187u, 128u, 131u, 133u, 159u, 161u, 162u, 169u, 
	178u, 180u, 183u, 130u, 135u, 137u, 139u, 148u, 
	151u, 153u, 155u, 157u, 159u, 164u, 190u, 141u, 
	143u, 145u, 146u, 161u, 162u, 167u, 170u, 172u, 
	178u, 180u, 183u, 185u, 188u, 128u, 137u, 139u, 
	155u, 161u, 163u, 165u, 169u, 171u, 187u, 132u, 
	155u, 128u, 191u, 128u, 150u, 156u, 160u, 128u, 
	191u, 128u, 180u, 186u, 128u, 185u, 128u, 161u, 
	168u, 160u, 167u, 128u, 157u, 160u, 135u, 132u, 
	134u, 128u, 175u, 48u, 57u, 48u, 49u, 50u, 
	51u, 57u, 65u, 90u, 97u, 122u, 45u, 46u, 
	48u, 57u, 65u, 90u, 97u, 122u, 48u, 49u, 
	50u, 51u, 57u, 65u, 90u, 97u, 122u, 45u, 
	46u, 48u, 57u, 65u, 90u, 97u, 122u, 48u, 
	49u, 50u, 51u, 57u, 65u, 90u, 97u, 122u, 
	45u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	45u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	45u, 46u, 53u, 48u, 52u, 54u, 57u, 65u, 
	90u, 97u, 122u, 45u, 46u, 48u, 53u, 54u, 
	57u, 65u, 90u, 97u, 122u, 45u, 46u, 48u, 
	57u, 65u, 90u, 97u, 122u, 45u, 46u, 48u, 
	57u, 65u, 90u, 97u, 122u, 45u, 46u, 53u, 
	48u, 52u, 54u, 57u, 65u, 90u, 97u, 122u, 
	45u, 46u, 48u, 53u, 54u, 57u, 65u, 90u, 
	97u, 122u, 45u, 46u, 48u, 57u, 65u, 90u, 
	97u, 122u, 45u, 46u, 48u, 57u, 65u, 90u, 
	97u, 122u, 45u, 46u, 53u, 48u, 52u, 54u, 
	57u, 65u, 90u, 97u, 122u, 45u, 46u, 48u, 
	53u, 54u, 57u, 65u, 90u, 97u, 122u, 48u, 
	49u, 50u, 51u, 57u, 65u, 90u, 97u, 122u, 
	45u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	45u, 48u, 57u, 65u, 90u, 97u, 122u, 45u, 
	46u, 48u, 57u, 65u, 90u, 97u, 122u, 48u, 
	57u, 65u, 90u, 97u, 122u, 45u, 46u, 48u, 
	57u, 65u, 90u, 97u, 122u, 48u, 49u, 50u, 
	51u, 57u, 65u, 90u, 97u, 122u, 45u, 46u, 
	48u, 57u, 65u, 90u, 97u, 122u, 48u, 49u, 
	50u, 51u, 57u, 65u, 90u, 97u, 122u, 45u, 
	46u, 48u, 57u, 65u, 90u, 97u, 122u, 48u, 
	49u, 50u, 51u, 57u, 65u, 90u, 97u, 122u, 
	45u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	45u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	45u, 46u, 53u, 48u, 52u, 54u, 57u, 65u, 
	90u, 97u, 122u, 45u, 46u, 48u, 53u, 54u, 
	57u, 65u, 90u, 97u, 122u, 45u, 46u, 48u, 
	57u, 65u, 90u, 97u, 122u, 45u, 46u, 48u, 
	57u, 65u, 90u, 97u, 122u, 45u, 46u, 53u, 
	48u, 52u, 54u, 57u, 65u, 90u, 97u, 122u, 
	45u, 46u, 48u, 53u, 54u, 57u, 65u, 90u, 
	97u, 122u, 45u, 46u, 48u, 57u, 65u, 90u, 
	97u, 122u, 45u, 46u, 48u, 57u, 65u, 90u, 
	97u, 122u, 45u, 46u, 53u, 48u, 52u, 54u, 
	57u, 65u, 90u, 97u, 122u, 45u, 46u, 48u, 
	53u, 54u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 58u, 64u, 95u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 58u, 64u, 95u, 36u, 37u, 39u, 46u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 95u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 58u, 
	64u, 95u, 36u, 37u, 39u, 46u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 58u, 
	64u, 95u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 95u, 36u, 37u, 
	39u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 48u, 49u, 50u, 58u, 64u, 95u, 36u, 
	37u, 39u, 46u, 51u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 58u, 64u, 95u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 48u, 49u, 50u, 58u, 64u, 95u, 
	36u, 37u, 39u, 46u, 51u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 58u, 64u, 95u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 48u, 49u, 50u, 58u, 64u, 
	95u, 36u, 37u, 39u, 46u, 51u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	95u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	95u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 53u, 58u, 
	64u, 95u, 36u, 37u, 39u, 44u, 48u, 52u, 
	54u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 95u, 36u, 37u, 39u, 44u, 
	48u, 53u, 54u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 95u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 95u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 53u, 58u, 64u, 95u, 36u, 
	37u, 39u, 44u, 48u, 52u, 54u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	95u, 36u, 37u, 39u, 44u, 48u, 53u, 54u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	58u, 64u, 95u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	58u, 64u, 95u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	53u, 58u, 64u, 95u, 36u, 37u, 39u, 44u, 
	48u, 52u, 54u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 95u, 36u, 37u, 
	39u, 44u, 48u, 53u, 54u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 58u, 64u, 95u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 58u, 64u, 95u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 58u, 64u, 95u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 47u, 95u, 36u, 37u, 39u, 
	57u, 65u, 90u, 97u, 122u, 47u, 33u, 48u, 
	49u, 50u, 95u, 36u, 37u, 39u, 46u, 51u, 
	57u, 65u, 90u, 97u, 122u, 33u, 58u, 64u, 
	95u, 36u, 37u, 39u, 46u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	95u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 58u, 64u, 95u, 
	36u, 37u, 39u, 46u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 58u, 64u, 95u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 58u, 64u, 95u, 36u, 37u, 
	39u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 95u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 48u, 49u, 50u, 58u, 64u, 95u, 36u, 
	37u, 39u, 46u, 51u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 58u, 64u, 95u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 48u, 49u, 50u, 58u, 64u, 95u, 
	36u, 37u, 39u, 46u, 51u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 58u, 64u, 95u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 48u, 49u, 50u, 58u, 64u, 
	95u, 36u, 37u, 39u, 46u, 51u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	95u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	95u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 53u, 58u, 
	64u, 95u, 36u, 37u, 39u, 44u, 48u, 52u, 
	54u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 95u, 36u, 37u, 39u, 44u, 
	48u, 53u, 54u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 95u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 95u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 53u, 58u, 64u, 95u, 36u, 
	37u, 39u, 44u, 48u, 52u, 54u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	95u, 36u, 37u, 39u, 44u, 48u, 53u, 54u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	58u, 64u, 95u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	58u, 64u, 95u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	53u, 58u, 64u, 95u, 36u, 37u, 39u, 44u, 
	48u, 52u, 54u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 95u, 36u, 37u, 
	39u, 44u, 48u, 53u, 54u, 57u, 65u, 90u, 
	97u, 122u, 45u, 46u, 47u, 58u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 39u, 40u, 44u, 
	46u, 61u, 63u, 95u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 297u, 553u, 36u, 38u, 42u, 57u, 58u, 
	59u, 64u, 90u, 97u, 122u, 196u, 218u, 229u, 
	236u, 47u, 48u, 57u, 45u, 46u, 47u, 58u, 
	48u, 57u, 65u, 90u, 97u, 122u, 45u, 46u, 
	47u, 58u, 48u, 57u, 65u, 90u, 97u, 122u, 
	45u, 46u, 47u, 58u, 48u, 57u, 65u, 90u, 
	97u, 122u, 45u, 46u, 47u, 53u, 58u, 48u, 
	52u, 54u, 57u, 65u, 90u, 97u, 122u, 45u, 
	46u, 47u, 58u, 48u, 53u, 54u, 57u, 65u, 
	90u, 97u, 122u, 45u, 46u, 47u, 58u, 48u, 
	57u, 65u, 90u, 97u, 122u, 45u, 46u, 47u, 
	58u, 48u, 57u, 65u, 90u, 97u, 122u, 45u, 
	46u, 47u, 58u, 48u, 57u, 65u, 90u, 97u, 
	122u, 45u, 46u, 47u, 58u, 48u, 57u, 65u, 
	90u, 97u, 122u, 45u, 46u, 47u, 53u, 58u, 
	48u, 52u, 54u, 57u, 65u, 90u, 97u, 122u, 
	45u, 46u, 47u, 58u, 48u, 53u, 54u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 47u, 
	58u, 64u, 95u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 47u, 64u, 
	95u, 36u, 37u, 39u, 46u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 47u, 58u, 
	64u, 95u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 47u, 
	58u, 64u, 95u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	47u, 58u, 64u, 95u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 47u, 53u, 58u, 64u, 95u, 36u, 37u, 
	39u, 44u, 48u, 52u, 54u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 47u, 58u, 64u, 
	95u, 36u, 37u, 39u, 44u, 48u, 53u, 54u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	47u, 58u, 64u, 95u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 47u, 58u, 64u, 95u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 47u, 58u, 64u, 95u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 47u, 58u, 64u, 95u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 47u, 53u, 58u, 64u, 
	95u, 36u, 37u, 39u, 44u, 48u, 52u, 54u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	47u, 58u, 64u, 95u, 36u, 37u, 39u, 44u, 
	48u, 53u, 54u, 57u, 65u, 90u, 97u, 122u, 
	0
};

static const char _url_detector_single_lengths[] = {
	0, 5, 4, 2, 3, 3, 2, 1, 
	2, 0, 2, 39, 2, 0, 0, 2, 
	1, 2, 0, 0, 0, 1, 1, 1, 
	0, 0, 1, 0, 0, 0, 1, 32, 
	0, 0, 0, 0, 0, 1, 1, 1, 
	2, 0, 2, 0, 0, 1, 2, 0, 
	0, 0, 1, 0, 1, 1, 2, 0, 
	0, 5, 1, 4, 0, 0, 1, 38, 
	0, 0, 2, 1, 0, 1, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 1, 0, 0, 0, 0, 
	0, 0, 3, 1, 0, 20, 1, 0, 
	0, 6, 1, 0, 0, 0, 0, 0, 
	0, 0, 1, 2, 2, 0, 0, 1, 
	11, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 0, 1, 0, 20, 0, 
	0, 0, 1, 0, 0, 0, 0, 2, 
	0, 0, 1, 0, 0, 0, 0, 0, 
	0, 2, 0, 0, 17, 0, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 14, 38, 1, 0, 0, 
	0, 0, 0, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 3, 0, 0, 0, 
	0, 0, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 23, 1, 0, 0, 
	1, 1, 0, 1, 0, 0, 2, 1, 
	0, 1, 2, 0, 1, 3, 0, 0, 
	1, 1, 0, 9, 0, 0, 0, 0, 
	0, 0, 4, 0, 0, 0, 18, 0, 
	0, 0, 0, 0, 2, 0, 0, 1, 
	0, 1, 0, 0, 0, 0, 0, 1, 
	1, 4, 0, 4, 12, 0, 1, 1, 
	0, 2, 0, 1, 0, 1, 0, 1, 
	1, 0, 0, 3, 2, 3, 2, 3, 
	2, 2, 3, 2, 2, 2, 3, 2, 
	2, 2, 3, 2, 3, 2, 1, 2, 
	0, 2, 3, 2, 3, 2, 3, 2, 
	2, 3, 2, 2, 2, 3, 2, 2, 
	2, 3, 2, 6, 5, 6, 4, 6, 
	2, 7, 6, 7, 6, 7, 6, 6, 
	7, 6, 6, 6, 7, 6, 6, 6, 
	7, 6, 6, 6, 6, 3, 1, 5, 
	4, 6, 5, 6, 4, 6, 7, 6, 
	7, 6, 7, 6, 6, 7, 6, 6, 
	6, 7, 6, 6, 6, 7, 6, 4, 
	39, 1, 4, 4, 4, 5, 4, 4, 
	4, 4, 4, 5, 4, 7, 4, 7, 
	7, 7, 8, 7, 7, 7, 7, 7, 
	8, 7
};

static const char _url_detector_range_lengths[] = {
	0, 5, 5, 5, 5, 3, 3, 3, 
	3, 3, 3, 7, 3, 3, 1, 3, 
	3, 3, 2, 2, 2, 2, 2, 4, 
	2, 2, 4, 1, 2, 1, 1, 0, 
	1, 1, 1, 1, 3, 7, 7, 9, 
	5, 8, 5, 8, 8, 10, 4, 6, 
	8, 7, 7, 5, 6, 4, 5, 1, 
	2, 8, 4, 3, 3, 3, 0, 3, 
	2, 2, 3, 5, 5, 3, 3, 3, 
	2, 2, 1, 2, 2, 2, 3, 4, 
	4, 3, 1, 2, 1, 3, 2, 2, 
	2, 2, 2, 3, 3, 1, 2, 3, 
	2, 3, 4, 2, 7, 0, 2, 2, 
	1, 5, 2, 1, 1, 1, 1, 1, 
	2, 2, 2, 2, 1, 5, 5, 0, 
	1, 4, 4, 2, 2, 3, 1, 1, 
	2, 2, 2, 1, 1, 1, 1, 1, 
	1, 2, 2, 2, 3, 1, 2, 3, 
	2, 2, 2, 1, 4, 4, 6, 3, 
	3, 1, 2, 2, 1, 1, 5, 3, 
	1, 1, 2, 2, 2, 2, 1, 2, 
	2, 1, 4, 1, 2, 4, 2, 1, 
	1, 1, 1, 0, 2, 2, 2, 3, 
	2, 2, 1, 2, 3, 3, 2, 3, 
	2, 2, 6, 2, 1, 3, 3, 2, 
	1, 1, 2, 1, 1, 2, 2, 2, 
	1, 4, 2, 5, 2, 8, 6, 2, 
	2, 1, 1, 3, 1, 2, 1, 1, 
	1, 1, 1, 1, 2, 2, 5, 1, 
	2, 1, 0, 1, 2, 3, 1, 3, 
	3, 1, 1, 2, 6, 2, 6, 3, 
	2, 3, 3, 3, 3, 3, 2, 1, 
	2, 1, 2, 5, 7, 5, 0, 1, 
	1, 1, 1, 1, 1, 1, 1, 0, 
	1, 1, 1, 3, 3, 3, 3, 3, 
	3, 3, 4, 4, 3, 3, 4, 4, 
	3, 3, 4, 4, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 4, 4, 3, 3, 4, 4, 3, 
	3, 4, 4, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	6, 6, 5, 5, 6, 6, 5, 5, 
	6, 6, 5, 5, 5, 4, 0, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 6, 6, 5, 
	5, 6, 6, 5, 5, 6, 6, 3, 
	7, 1, 3, 3, 3, 4, 4, 3, 
	3, 3, 3, 4, 4, 5, 5, 5, 
	5, 5, 6, 6, 5, 5, 5, 5, 
	6, 6
};

static const short _url_detector_index_offsets[] = {
	0, 0, 11, 21, 29, 38, 45, 51, 
	56, 62, 66, 72, 119, 125, 129, 131, 
	137, 142, 148, 151, 154, 157, 161, 165, 
	171, 174, 177, 183, 185, 188, 190, 193, 
	226, 228, 230, 232, 234, 238, 247, 256, 
	267, 275, 284, 292, 301, 310, 322, 329, 
	336, 345, 353, 362, 368, 376, 382, 390, 
	392, 395, 409, 415, 423, 427, 431, 433, 
	475, 478, 481, 487, 494, 500, 505, 509, 
	513, 516, 519, 521, 524, 527, 530, 534, 
	539, 545, 549, 551, 554, 556, 560, 563, 
	566, 569, 572, 576, 581, 585, 587, 590, 
	594, 597, 601, 609, 613, 621, 642, 646, 
	649, 651, 663, 667, 669, 671, 673, 675, 
	677, 680, 683, 687, 692, 696, 702, 708, 
	710, 723, 728, 733, 736, 739, 743, 745, 
	747, 750, 753, 757, 759, 762, 764, 786, 
	788, 790, 793, 797, 800, 804, 806, 809, 
	815, 818, 821, 825, 827, 832, 837, 844, 
	848, 852, 856, 859, 862, 881, 883, 890, 
	894, 896, 898, 901, 904, 907, 910, 912, 
	915, 918, 920, 925, 941, 982, 988, 991, 
	993, 995, 997, 999, 1001, 1004, 1007, 1010, 
	1014, 1017, 1020, 1022, 1025, 1032, 1036, 1039, 
	1043, 1046, 1049, 1057, 1060, 1062, 1066, 1070, 
	1073, 1075, 1077, 1080, 1082, 1107, 1111, 1114, 
	1117, 1120, 1126, 1129, 1136, 1139, 1148, 1157, 
	1161, 1164, 1167, 1171, 1175, 1178, 1184, 1186, 
	1188, 1191, 1194, 1196, 1207, 1210, 1213, 1219, 
	1221, 1224, 1226, 1231, 1233, 1236, 1240, 1260, 
	1264, 1268, 1270, 1272, 1275, 1284, 1287, 1294, 
	1299, 1302, 1307, 1311, 1315, 1319, 1323, 1326, 
	1329, 1333, 1339, 1342, 1352, 1372, 1378, 1380, 
	1383, 1385, 1389, 1391, 1394, 1396, 1399, 1401, 
	1403, 1406, 1408, 1410, 1417, 1423, 1430, 1436, 
	1443, 1449, 1455, 1463, 1470, 1476, 1482, 1490, 
	1497, 1503, 1509, 1517, 1524, 1531, 1537, 1542, 
	1548, 1552, 1558, 1565, 1571, 1578, 1584, 1591, 
	1597, 1603, 1611, 1618, 1624, 1630, 1638, 1645, 
	1651, 1657, 1665, 1672, 1684, 1695, 1707, 1717, 
	1729, 1737, 1750, 1762, 1775, 1787, 1800, 1812, 
	1824, 1838, 1851, 1863, 1875, 1889, 1902, 1914, 
	1926, 1940, 1953, 1965, 1977, 1989, 1997, 1999, 
	2010, 2020, 2032, 2043, 2055, 2065, 2077, 2090, 
	2102, 2115, 2127, 2140, 2152, 2164, 2178, 2191, 
	2203, 2215, 2229, 2242, 2254, 2266, 2280, 2293, 
	2301, 2348, 2351, 2359, 2367, 2375, 2385, 2394, 
	2402, 2410, 2418, 2426, 2436, 2445, 2458, 2468, 
	2481, 2494, 2507, 2522, 2536, 2549, 2562, 2575, 
	2588, 2603
};

static const short _url_detector_indicies[] = {
	0, 2, 3, 4, 0, 0, 0, 5, 
	6, 6, 1, 0, 7, 8, 0, 0, 
	0, 0, 0, 0, 1, 9, 9, 9, 
	9, 9, 9, 9, 1, 9, 10, 9, 
	9, 9, 9, 9, 9, 1, 11, 12, 
	13, 14, 15, 15, 1, 16, 17, 15, 
	15, 15, 1, 16, 15, 15, 15, 1, 
	16, 18, 15, 15, 15, 1, 15, 19, 
	19, 1, 16, 18, 15, 20, 20, 1, 
	21, 21, 23, 21, 21, 22, 21, 22, 
	24, 25, 27, 28, 29, 30, 31, 32, 
	33, 34, 35, 36, 37, 38, 39, 40, 
	41, 42, 43, 44, 45, 46, 47, 49, 
	50, 51, 52, 53, 54, 55, 56, 22, 
	22, 21, 22, 22, 26, 48, 1, 22, 
	22, 22, 22, 22, 1, 22, 22, 22, 
	1, 22, 1, 22, 22, 22, 22, 22, 
	1, 22, 22, 22, 22, 1, 22, 22, 
	22, 22, 22, 1, 22, 22, 1, 22, 
	22, 1, 22, 22, 1, 22, 22, 22, 
	1, 22, 22, 22, 1, 22, 22, 22, 
	22, 22, 1, 22, 22, 1, 22, 22, 
	1, 22, 22, 22, 22, 22, 1, 22, 
	1, 22, 22, 1, 22, 1, 22, 22, 
	1, 57, 58, 59, 60, 26, 61, 62, 
	63, 64, 65, 66, 67, 68, 69, 70, 
	71, 72, 73, 74, 75, 76, 77, 78, 
	79, 80, 81, 82, 83, 84, 85, 86, 
	87, 1, 22, 1, 22, 1, 22, 1, 
	22, 1, 22, 22, 22, 1, 22, 22, 
	22, 22, 22, 22, 22, 22, 1, 22, 
	22, 22, 22, 22, 22, 22, 22, 1, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 1, 22, 22, 22, 22, 22, 
	22, 22, 1, 22, 22, 22, 22, 22, 
	22, 22, 22, 1, 22, 22, 22, 22, 
	22, 22, 22, 1, 22, 22, 22, 22, 
	22, 22, 22, 22, 1, 22, 22, 22, 
	22, 22, 22, 22, 22, 1, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 1, 22, 22, 22, 22, 22, 22, 
	1, 22, 22, 22, 22, 22, 22, 1, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	1, 22, 22, 22, 22, 22, 22, 22, 
	1, 22, 22, 22, 22, 22, 22, 22, 
	22, 1, 22, 22, 22, 22, 22, 1, 
	22, 22, 22, 22, 22, 22, 22, 1, 
	22, 22, 22, 22, 22, 1, 22, 22, 
	22, 22, 22, 22, 22, 1, 22, 1, 
	22, 22, 1, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	1, 22, 22, 22, 22, 22, 1, 22, 
	22, 22, 22, 22, 22, 22, 1, 22, 
	22, 22, 1, 22, 22, 22, 1, 22, 
	1, 88, 89, 90, 91, 92, 93, 94, 
	95, 96, 97, 98, 99, 100, 101, 102, 
	103, 104, 105, 106, 107, 108, 109, 110, 
	111, 112, 113, 114, 115, 116, 117, 106, 
	118, 119, 120, 121, 122, 123, 124, 26, 
	26, 26, 1, 22, 22, 1, 22, 22, 
	1, 22, 22, 22, 22, 22, 1, 22, 
	22, 22, 22, 22, 22, 1, 22, 22, 
	22, 22, 22, 1, 22, 22, 22, 22, 
	1, 22, 22, 22, 1, 22, 22, 22, 
	1, 22, 22, 1, 22, 22, 1, 22, 
	1, 22, 22, 1, 22, 22, 1, 22, 
	22, 1, 22, 22, 22, 1, 22, 22, 
	22, 22, 1, 22, 22, 22, 22, 22, 
	1, 22, 22, 22, 1, 22, 1, 22, 
	22, 1, 22, 1, 22, 22, 22, 1, 
	22, 22, 1, 22, 22, 1, 22, 22, 
	1, 22, 22, 1, 22, 22, 22, 1, 
	22, 22, 22, 22, 1, 22, 22, 22, 
	1, 22, 1, 22, 22, 1, 22, 22, 
	22, 1, 22, 22, 1, 22, 22, 22, 
	1, 22, 22, 22, 22, 22, 22, 22, 
	1, 22, 22, 22, 1, 22, 22, 22, 
	22, 22, 22, 22, 1, 125, 126, 127, 
	128, 129, 130, 131, 58, 132, 133, 134, 
	135, 136, 26, 137, 138, 139, 140, 141, 
	142, 1, 22, 22, 22, 1, 22, 22, 
	1, 22, 1, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 1, 22, 
	22, 22, 1, 22, 1, 22, 1, 22, 
	1, 22, 1, 22, 1, 22, 22, 1, 
	22, 22, 1, 22, 22, 22, 1, 22, 
	22, 22, 22, 1, 22, 22, 22, 1, 
	22, 22, 22, 22, 22, 1, 22, 22, 
	22, 22, 22, 1, 22, 1, 143, 98, 
	144, 145, 146, 26, 147, 148, 149, 150, 
	151, 26, 1, 22, 22, 22, 22, 1, 
	22, 22, 22, 22, 1, 22, 22, 1, 
	22, 22, 1, 22, 22, 22, 1, 22, 
	1, 22, 1, 22, 22, 1, 22, 22, 
	1, 108, 26, 26, 1, 26, 1, 152, 
	26, 1, 22, 1, 153, 154, 155, 156, 
	41, 157, 158, 159, 160, 117, 161, 162, 
	163, 164, 165, 166, 167, 168, 169, 170, 
	26, 1, 22, 1, 22, 1, 22, 22, 
	1, 22, 22, 22, 1, 22, 22, 1, 
	22, 22, 22, 1, 22, 1, 22, 22, 
	1, 22, 22, 22, 22, 22, 1, 22, 
	22, 1, 22, 22, 1, 22, 22, 22, 
	1, 22, 1, 22, 22, 22, 22, 1, 
	22, 22, 22, 22, 1, 22, 22, 22, 
	22, 22, 22, 1, 22, 22, 22, 1, 
	22, 22, 22, 1, 171, 172, 26, 1, 
	22, 22, 1, 22, 22, 1, 162, 173, 
	174, 175, 41, 176, 177, 39, 178, 179, 
	180, 181, 182, 183, 184, 185, 186, 26, 
	1, 22, 1, 22, 22, 22, 22, 22, 
	22, 1, 22, 22, 22, 1, 22, 1, 
	22, 1, 22, 22, 1, 22, 22, 1, 
	22, 22, 1, 22, 22, 1, 22, 1, 
	22, 22, 1, 22, 22, 1, 22, 1, 
	22, 22, 22, 22, 1, 187, 188, 189, 
	190, 191, 192, 193, 194, 195, 196, 197, 
	198, 199, 200, 48, 1, 201, 202, 26, 
	203, 204, 205, 206, 207, 208, 209, 171, 
	210, 89, 211, 212, 213, 214, 165, 215, 
	216, 217, 218, 219, 220, 221, 178, 222, 
	223, 224, 225, 108, 226, 227, 26, 228, 
	229, 230, 231, 26, 26, 1, 22, 22, 
	22, 22, 22, 1, 22, 22, 1, 22, 
	1, 22, 1, 22, 1, 22, 1, 22, 
	1, 22, 22, 1, 22, 22, 1, 22, 
	22, 1, 22, 22, 22, 1, 22, 22, 
	1, 22, 22, 1, 22, 1, 22, 22, 
	1, 22, 22, 22, 22, 22, 22, 1, 
	22, 22, 22, 1, 22, 22, 1, 22, 
	22, 22, 1, 22, 22, 1, 22, 22, 
	1, 22, 22, 22, 22, 22, 22, 22, 
	1, 22, 22, 1, 22, 1, 22, 22, 
	22, 1, 22, 22, 22, 1, 22, 22, 
	1, 22, 1, 22, 1, 22, 22, 1, 
	22, 1, 232, 203, 233, 234, 235, 236, 
	237, 238, 239, 240, 241, 26, 242, 243, 
	244, 26, 245, 106, 130, 246, 131, 247, 
	205, 26, 1, 22, 22, 22, 1, 22, 
	22, 1, 22, 22, 1, 22, 22, 1, 
	22, 22, 22, 22, 22, 1, 22, 22, 
	1, 22, 22, 22, 22, 22, 22, 1, 
	22, 22, 1, 22, 22, 22, 22, 22, 
	22, 22, 22, 1, 22, 22, 22, 22, 
	22, 22, 22, 22, 1, 22, 22, 22, 
	1, 22, 22, 1, 22, 22, 1, 22, 
	22, 22, 1, 22, 22, 22, 1, 22, 
	22, 1, 173, 248, 249, 26, 26, 1, 
	22, 1, 22, 1, 248, 26, 1, 250, 
	26, 1, 22, 1, 205, 251, 252, 165, 
	253, 254, 26, 255, 256, 26, 1, 22, 
	22, 1, 22, 22, 1, 22, 22, 22, 
	22, 22, 1, 22, 1, 22, 22, 1, 
	22, 1, 257, 26, 258, 259, 1, 22, 
	1, 22, 22, 1, 22, 22, 22, 1, 
	260, 261, 262, 263, 264, 265, 266, 267, 
	268, 269, 270, 271, 272, 273, 274, 275, 
	276, 277, 26, 1, 22, 22, 22, 1, 
	22, 22, 22, 1, 22, 1, 22, 1, 
	22, 22, 1, 22, 22, 22, 22, 22, 
	22, 22, 22, 1, 22, 22, 1, 22, 
	22, 22, 22, 22, 22, 1, 22, 22, 
	22, 22, 1, 22, 22, 1, 22, 22, 
	22, 22, 1, 22, 22, 22, 1, 22, 
	22, 22, 1, 22, 22, 22, 1, 22, 
	22, 22, 1, 22, 22, 1, 22, 22, 
	1, 22, 22, 22, 1, 278, 279, 280, 
	281, 26, 1, 22, 22, 1, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 1, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 1, 22, 22, 22, 22, 
	22, 1, 153, 1, 282, 26, 1, 22, 
	1, 283, 89, 26, 1, 22, 1, 284, 
	26, 1, 22, 1, 285, 26, 1, 22, 
	1, 286, 1, 287, 26, 1, 22, 1, 
	288, 1, 289, 290, 291, 292, 19, 19, 
	1, 16, 293, 15, 15, 15, 1, 294, 
	295, 296, 297, 19, 19, 1, 16, 298, 
	15, 15, 15, 1, 299, 300, 301, 302, 
	19, 19, 1, 16, 298, 297, 15, 15, 
	1, 16, 298, 294, 15, 15, 1, 16, 
	298, 303, 297, 294, 15, 15, 1, 16, 
	298, 294, 15, 15, 15, 1, 16, 293, 
	292, 15, 15, 1, 16, 293, 289, 15, 
	15, 1, 16, 293, 304, 292, 289, 15, 
	15, 1, 16, 293, 289, 15, 15, 15, 
	1, 16, 17, 14, 15, 15, 1, 16, 
	17, 11, 15, 15, 1, 16, 17, 305, 
	14, 11, 15, 15, 1, 16, 17, 11, 
	15, 15, 15, 1, 306, 307, 308, 309, 
	310, 310, 1, 311, 312, 310, 310, 310, 
	1, 311, 310, 310, 310, 1, 311, 313, 
	310, 310, 310, 1, 310, 314, 314, 1, 
	311, 313, 310, 315, 315, 1, 316, 317, 
	318, 319, 314, 314, 1, 311, 320, 310, 
	310, 310, 1, 321, 322, 323, 324, 314, 
	314, 1, 311, 325, 310, 310, 310, 1, 
	326, 327, 328, 329, 314, 314, 1, 311, 
	325, 324, 310, 310, 1, 311, 325, 321, 
	310, 310, 1, 311, 325, 330, 324, 321, 
	310, 310, 1, 311, 325, 321, 310, 310, 
	310, 1, 311, 320, 319, 310, 310, 1, 
	311, 320, 316, 310, 310, 1, 311, 320, 
	331, 319, 316, 310, 310, 1, 311, 320, 
	316, 310, 310, 310, 1, 311, 312, 309, 
	310, 310, 1, 311, 312, 306, 310, 310, 
	1, 311, 312, 332, 309, 306, 310, 310, 
	1, 311, 312, 306, 310, 310, 310, 1, 
	0, 333, 334, 7, 8, 0, 0, 0, 
	335, 335, 335, 1, 0, 333, 7, 8, 
	0, 0, 0, 335, 335, 335, 1, 0, 
	333, 336, 7, 8, 0, 0, 0, 335, 
	335, 335, 1, 0, 7, 8, 0, 0, 
	0, 335, 337, 337, 1, 0, 333, 336, 
	7, 8, 0, 0, 0, 335, 338, 338, 
	1, 9, 9, 9, 9, 339, 9, 9, 
	1, 0, 340, 341, 342, 7, 8, 0, 
	0, 0, 343, 337, 337, 1, 0, 333, 
	344, 7, 8, 0, 0, 0, 335, 335, 
	335, 1, 0, 345, 346, 347, 7, 8, 
	0, 0, 0, 348, 337, 337, 1, 0, 
	333, 349, 7, 8, 0, 0, 0, 335, 
	335, 335, 1, 0, 350, 351, 352, 7, 
	8, 0, 0, 0, 353, 337, 337, 1, 
	0, 333, 349, 7, 8, 0, 0, 0, 
	348, 335, 335, 1, 0, 333, 349, 7, 
	8, 0, 0, 0, 345, 335, 335, 1, 
	0, 333, 349, 354, 7, 8, 0, 0, 
	0, 348, 345, 335, 335, 1, 0, 333, 
	349, 7, 8, 0, 0, 0, 345, 335, 
	335, 335, 1, 0, 333, 344, 7, 8, 
	0, 0, 0, 343, 335, 335, 1, 0, 
	333, 344, 7, 8, 0, 0, 0, 340, 
	335, 335, 1, 0, 333, 344, 355, 7, 
	8, 0, 0, 0, 343, 340, 335, 335, 
	1, 0, 333, 344, 7, 8, 0, 0, 
	0, 340, 335, 335, 335, 1, 0, 333, 
	334, 7, 8, 0, 0, 0, 5, 335, 
	335, 1, 0, 333, 334, 7, 8, 0, 
	0, 0, 2, 335, 335, 1, 0, 333, 
	334, 356, 7, 8, 0, 0, 0, 5, 
	2, 335, 335, 1, 0, 333, 334, 7, 
	8, 0, 0, 0, 2, 335, 335, 335, 
	1, 0, 333, 336, 7, 8, 0, 0, 
	0, 335, 357, 357, 1, 0, 333, 336, 
	7, 8, 0, 0, 0, 335, 358, 358, 
	1, 0, 333, 336, 359, 8, 0, 0, 
	0, 335, 358, 358, 1, 9, 360, 9, 
	9, 9, 9, 9, 1, 361, 1, 362, 
	363, 364, 365, 362, 362, 362, 366, 367, 
	367, 1, 362, 7, 10, 362, 362, 362, 
	362, 362, 362, 1, 362, 368, 369, 7, 
	10, 362, 362, 362, 367, 367, 367, 1, 
	362, 368, 7, 10, 362, 362, 362, 367, 
	367, 367, 1, 362, 368, 370, 7, 10, 
	362, 362, 362, 367, 367, 367, 1, 362, 
	7, 10, 362, 362, 362, 367, 371, 371, 
	1, 362, 368, 370, 7, 10, 362, 362, 
	362, 367, 372, 372, 1, 362, 373, 374, 
	375, 7, 10, 362, 362, 362, 376, 371, 
	371, 1, 362, 368, 377, 7, 10, 362, 
	362, 362, 367, 367, 367, 1, 362, 378, 
	379, 380, 7, 10, 362, 362, 362, 381, 
	371, 371, 1, 362, 368, 382, 7, 10, 
	362, 362, 362, 367, 367, 367, 1, 362, 
	383, 384, 385, 7, 10, 362, 362, 362, 
	386, 371, 371, 1, 362, 368, 382, 7, 
	10, 362, 362, 362, 381, 367, 367, 1, 
	362, 368, 382, 7, 10, 362, 362, 362, 
	378, 367, 367, 1, 362, 368, 382, 387, 
	7, 10, 362, 362, 362, 381, 378, 367, 
	367, 1, 362, 368, 382, 7, 10, 362, 
	362, 362, 378, 367, 367, 367, 1, 362, 
	368, 377, 7, 10, 362, 362, 362, 376, 
	367, 367, 1, 362, 368, 377, 7, 10, 
	362, 362, 362, 373, 367, 367, 1, 362, 
	368, 377, 388, 7, 10, 362, 362, 362, 
	376, 373, 367, 367, 1, 362, 368, 377, 
	7, 10, 362, 362, 362, 373, 367, 367, 
	367, 1, 362, 368, 369, 7, 10, 362, 
	362, 362, 366, 367, 367, 1, 362, 368, 
	369, 7, 10, 362, 362, 362, 363, 367, 
	367, 1, 362, 368, 369, 389, 7, 10, 
	362, 362, 362, 366, 363, 367, 367, 1, 
	362, 368, 369, 7, 10, 362, 362, 362, 
	363, 367, 367, 367, 1, 16, 18, 22, 
	390, 15, 20, 20, 1, 21, 21, 23, 
	21, 21, 22, 21, 22, 24, 25, 27, 
	28, 29, 30, 31, 32, 33, 34, 35, 
	36, 37, 38, 39, 40, 41, 42, 43, 
	44, 45, 46, 47, 49, 50, 51, 52, 
	53, 54, 55, 56, 22, 22, 21, 22, 
	22, 26, 48, 1, 22, 288, 1, 16, 
	18, 22, 390, 15, 15, 15, 1, 16, 
	18, 22, 390, 302, 15, 15, 1, 16, 
	18, 22, 390, 299, 15, 15, 1, 16, 
	18, 22, 391, 390, 302, 299, 15, 15, 
	1, 16, 18, 22, 390, 299, 15, 15, 
	15, 1, 311, 313, 22, 390, 310, 315, 
	315, 1, 311, 313, 22, 390, 310, 310, 
	310, 1, 311, 313, 22, 390, 329, 310, 
	310, 1, 311, 313, 22, 390, 326, 310, 
	310, 1, 311, 313, 22, 392, 390, 329, 
	326, 310, 310, 1, 311, 313, 22, 390, 
	326, 310, 310, 310, 1, 0, 333, 336, 
	22, 393, 8, 0, 0, 0, 335, 338, 
	338, 1, 9, 22, 10, 9, 9, 9, 
	339, 9, 9, 1, 0, 333, 336, 22, 
	393, 8, 0, 0, 0, 335, 335, 335, 
	1, 0, 333, 336, 22, 393, 8, 0, 
	0, 0, 353, 335, 335, 1, 0, 333, 
	336, 22, 393, 8, 0, 0, 0, 350, 
	335, 335, 1, 0, 333, 336, 22, 394, 
	393, 8, 0, 0, 0, 353, 350, 335, 
	335, 1, 0, 333, 336, 22, 393, 8, 
	0, 0, 0, 350, 335, 335, 335, 1, 
	362, 368, 370, 22, 393, 10, 362, 362, 
	362, 367, 372, 372, 1, 362, 368, 370, 
	22, 393, 10, 362, 362, 362, 367, 367, 
	367, 1, 362, 368, 370, 22, 393, 10, 
	362, 362, 362, 386, 367, 367, 1, 362, 
	368, 370, 22, 393, 10, 362, 362, 362, 
	383, 367, 367, 1, 362, 368, 370, 22, 
	395, 393, 10, 362, 362, 362, 386, 383, 
	367, 367, 1, 362, 368, 370, 22, 393, 
	10, 362, 362, 362, 383, 367, 367, 367, 
	1, 0
};

static const short _url_detector_trans_targs[] = {
	2, 0, 315, 334, 336, 335, 338, 3, 
	292, 4, 5, 6, 288, 290, 289, 8, 
	7, 275, 9, 10, 367, 11, 368, 368, 
	12, 13, 14, 15, 16, 17, 18, 19, 
	20, 21, 22, 23, 24, 25, 26, 27, 
	28, 29, 30, 31, 63, 101, 120, 130, 
	131, 132, 134, 153, 156, 171, 271, 11, 
	368, 32, 33, 34, 35, 36, 37, 38, 
	39, 40, 41, 42, 43, 44, 45, 46, 
	47, 48, 49, 50, 51, 52, 53, 54, 
	55, 56, 57, 58, 59, 60, 61, 62, 
	64, 65, 66, 67, 68, 69, 70, 71, 
	72, 73, 74, 75, 76, 77, 78, 79, 
	80, 81, 82, 83, 84, 85, 86, 87, 
	88, 89, 90, 91, 92, 93, 94, 95, 
	96, 97, 98, 99, 100, 102, 103, 104, 
	105, 106, 107, 108, 109, 110, 111, 112, 
	113, 114, 115, 116, 117, 118, 119, 121, 
	122, 123, 124, 125, 126, 127, 128, 129, 
	133, 135, 136, 137, 138, 139, 140, 141, 
	142, 143, 144, 145, 146, 147, 148, 149, 
	150, 151, 152, 154, 155, 157, 158, 159, 
	160, 161, 162, 163, 164, 165, 166, 167, 
	168, 169, 170, 172, 204, 221, 224, 225, 
	227, 234, 238, 257, 262, 263, 265, 267, 
	269, 173, 174, 175, 176, 177, 178, 179, 
	180, 181, 182, 183, 184, 185, 186, 187, 
	188, 189, 190, 191, 192, 193, 194, 195, 
	196, 197, 198, 199, 200, 201, 202, 203, 
	205, 206, 207, 208, 209, 210, 211, 212, 
	213, 214, 215, 216, 217, 218, 219, 220, 
	222, 223, 226, 228, 229, 230, 231, 232, 
	233, 235, 236, 237, 239, 240, 241, 242, 
	243, 244, 245, 246, 247, 248, 249, 250, 
	251, 252, 253, 254, 255, 256, 258, 259, 
	260, 261, 264, 266, 268, 270, 272, 273, 
	369, 276, 284, 286, 285, 277, 278, 280, 
	282, 281, 279, 370, 371, 373, 372, 283, 
	287, 291, 293, 311, 313, 312, 295, 294, 
	298, 296, 297, 375, 299, 307, 309, 308, 
	300, 301, 303, 305, 304, 302, 376, 377, 
	379, 378, 306, 310, 314, 316, 321, 317, 
	318, 319, 381, 382, 322, 330, 332, 331, 
	323, 324, 326, 328, 327, 325, 383, 384, 
	386, 385, 329, 333, 337, 339, 340, 341, 
	342, 343, 344, 345, 363, 365, 364, 347, 
	346, 350, 348, 349, 388, 351, 359, 361, 
	360, 352, 353, 355, 357, 356, 354, 389, 
	390, 392, 391, 358, 362, 366, 274, 374, 
	380, 320, 387, 393
};

static const char _url_detector_trans_actions[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 1, 0, 1, 8, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 3, 
	11, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 1, 1, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 5, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 1, 
	1, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 1, 
	1, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	1, 1, 1, 0, 0, 0, 0, 1, 
	1, 0, 1, 1
};

static const int url_detector_start = 1;





url_detector::url_type url_detector::detect(string_piece str, size_t* length) {
  int cs;
  const char* p = str.str;

  url_type result = NO_URL;
  size_t result_length = 0, parens = 0;
  
	{
	cs = url_detector_start;
	}

	{
	int _klen;
	unsigned int _trans;
	short _widec;
	const char *_acts;
	unsigned int _nacts;
	const short *_keys;

	if ( p == ( (str.str + str.len)) )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_widec = (*p);
	_klen = _url_detector_cond_lengths[cs];
	_keys = _url_detector_cond_keys + (_url_detector_cond_offsets[cs]*2);
	if ( _klen > 0 ) {
		const short *_lower = _keys;
		const short *_mid;
		const short *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( _widec < _mid[0] )
				_upper = _mid - 2;
			else if ( _widec > _mid[1] )
				_lower = _mid + 2;
			else {
				switch ( _url_detector_cond_spaces[_url_detector_cond_offsets[cs] + ((_mid - _keys)>>1)] ) {
	case 0: {
		_widec = (short)(256u + ((*p) - 0u));
		if ( 
parens ) _widec += 256;
		break;
	}
				}
				break;
			}
		}
	}

	_keys = _url_detector_trans_keys + _url_detector_key_offsets[cs];
	_trans = _url_detector_index_offsets[cs];

	_klen = _url_detector_single_lengths[cs];
	if ( _klen > 0 ) {
		const short *_lower = _keys;
		const short *_mid;
		const short *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( _widec < *_mid )
				_upper = _mid - 1;
			else if ( _widec > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (unsigned int)(_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _url_detector_range_lengths[cs];
	if ( _klen > 0 ) {
		const short *_lower = _keys;
		const short *_mid;
		const short *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( _widec < _mid[0] )
				_upper = _mid - 2;
			else if ( _widec > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += (unsigned int)((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	_trans = _url_detector_indicies[_trans];
	cs = _url_detector_trans_targs[_trans];

	if ( _url_detector_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _url_detector_actions + _url_detector_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
	{ result = URL; result_length = p - str.str + 1; }
	break;
	case 1:
	{ result = EMAIL; result_length = p - str.str + 1; }
	break;
	case 2:
	{parens++;}
	break;
	case 3:
	{parens-=!!parens;}
	break;
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != ( (str.str + str.len)) )
		goto _resume;
	_test_eof: {}
	_out: {}
	}



//  if (result == URL) {
//    // Ignore the last character if it is one of [.!',;?:)],
//    // and the ) only if it is unmatched.
//    size_t unmatched_parens = 0;
//    bool unmatched_parens_computed = false;
//    do {
//      if (str.str[result_length-1] == ')' && !unmatched_parens_computed) {
//        for (size_t i = 
//
//
//        unmatched_parens_computed = true;
//      }
//    }  while ();
//    while (result_length) {
//
//
//    }
//
//    if (str.str[result_length-1] == '.' ||
//
//    // Also ignore ) is ignored only if there is not a matching left one.
//  }
//
  if (length) *length = result_length;
  return length || result_length == str.len ? result : NO_URL;
}

} // namespace utils
} // namespace nametag
} // namespace ufal
