% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nametagger.R
\name{predict.nametagger}
\alias{predict.nametagger}
\title{Perform Named Entity Recognition on tokenised text}
\usage{
\method{predict}{nametagger}(object, newdata, split = "[[:space:]]+", ...)
}
\arguments{
\item{object}{an object of class \code{nametagger} as returned by \code{\link{nametagger_load_model}}}

\item{newdata}{a data.frame with tokenised sentences. This data.frame should contain the columns doc_id, sentence_id and text where
\code{text} contains tokens in vertical format, meaning each token is put on a new line. Column doc_id should be of type character, column sentence_id of type integer.}

\item{split}{a regular expression used to split \code{newdata}. Only used if \code{newdata} is a character vector containing text which is not tokenised}

\item{...}{not used}
}
\value{
a data.frame with columns doc_id, sentence_id, token and entity
}
\description{
Perform Named Entity Recognition on tokenised text using a nametagger model
}
\examples{
path  <- system.file(package = "nametagger", "models", "exampletagger.ner")
model <- nametagger_load_model(path)
model

x <- c("I ga naar Brussel op reis.", "Goed zo dat zal je deugd doen Karel")
entities <- predict(model, x, split = "[[:space:][:punct:]]+")                          
entities

\donttest{
model <- nametagger_download_model("english-conll-140408", model_dir = tempdir())

x <- data.frame(doc_id = c(1, 1, 2),
                sentence_id = c(1, 2, 1),
                text = c("I\nlive\nin\nNew\nYork\nand\nI\nwork\nfor\nApple\nInc.", 
                         "Why\ndon't\nyou\ncome\nvisit\nme", 
                         "Good\nnews\nfrom\nAmazon\nas\nJohn\nworks\nthere\n."))
entities <- predict(model, x)                          
entities
}
}
