% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/determine_weights.R
\name{determine_weights_for_binary_outcomes}
\alias{determine_weights_for_binary_outcomes}
\title{Determine Weights Appropriately for Super Learner given Binary Outcomes}
\usage{
determine_weights_for_binary_outcomes(data, y_variable, obs_weights = NULL)
}
\arguments{
\item{data}{A data.frame with columns corresponding to predicted
probabilities of 1 from each learner and the true y_variable from held-out
data}

\item{y_variable}{A character indicating the outcome variable in the data.frame.}

\item{obs_weights}{A vector of weights for each observation that dictate
how prediction should be more targeted to higher weighted observations.}
}
\value{
A vector of weights to be used for each of the learners.
}
\description{
Determine Weights Appropriately for Super Learner given Binary Outcomes
}
\examples{
predicted_probabilities <- data.frame(
  logistic = lnr_logistic(mtcars, am ~ hp)(mtcars),
  nnet = lnr_nnet(mtcars, am ~ hp)(mtcars),
  am = mtcars$am)
determine_weights_for_binary_outcomes(predicted_probabilities, y_variable = 'am')
}
